/*
 * Decompiled with CFR 0.152.
 */
package quaternary.brokenwings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import quaternary.brokenwings.config.ListMode;
import quaternary.brokenwings.config.WingConfig;
import quaternary.brokenwings.countermeasures.Countermeasures;
import quaternary.brokenwings.countermeasures.ICountermeasure;

@Mod(modid="brokenwings", name="Broken Wings", version="2.0.0", guiFactory="quaternary.brokenwings.config.asdf.GuiFactoryBlahblah", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="brokenwings")
public class BrokenWings {
    public static final String MODID = "brokenwings";
    public static final String NAME = "Broken Wings";
    public static final String VERSION = "2.0.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"Broken Wings");
    public static final Map<String, Long> lastMessageTimes = new HashMap<String, Long>();
    public static final Random messageRandom = new Random();
    public static final int MESSAGE_COUNT = 9;
    private static final List<ICountermeasure> usedCountermeasures = new ArrayList<ICountermeasure>();

    @Mod.EventHandler
    public static void preinit(FMLPreInitializationEvent e) {
        WingConfig.preinit(e);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent e) {
        Countermeasures.createAll();
        WingConfig.init(e);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerTick(TickEvent.PlayerTickEvent e) {
        long now;
        if (WingConfig.MODE == ListMode.ALWAYS_ALLOW) {
            return;
        }
        EntityPlayer player = e.player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        if (!WingConfig.MODE.isFlightInDimensionBanned(player.field_71093_bK)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        usedCountermeasures.clear();
        for (ICountermeasure c2 : Countermeasures.ENABLED) {
            if (!c2.isFlying(playerMP)) continue;
            usedCountermeasures.add(c2);
        }
        if (usedCountermeasures.isEmpty()) {
            return;
        }
        if (BrokenWings.isPlayerImmune(playerMP, usedCountermeasures)) {
            return;
        }
        usedCountermeasures.forEach(c -> c.stopFlying(playerMP));
        playerMP.field_70159_w = 0.0;
        playerMP.field_70181_x -= 0.3;
        playerMP.field_70179_y = 0.0;
        playerMP.field_70160_al = true;
        playerMP.func_71121_q().func_73039_n().func_151248_b((Entity)playerMP, (Packet)new SPacketEntityVelocity((Entity)playerMP));
        if ((WingConfig.SEND_STATUS_MESSAGE || WingConfig.SHOW_PARTICLES || WingConfig.PRINT_TO_LOG) && (now = playerMP.func_71121_q().func_82737_E()) - lastMessageTimes.getOrDefault(playerMP.func_70005_c_(), 0L) > (long)(20 * WingConfig.EFFECT_INTERVAL)) {
            lastMessageTimes.put(playerMP.func_70005_c_(), now);
            if (WingConfig.SEND_STATUS_MESSAGE) {
                Object msg = WingConfig.FIXED_MESSAGE.isEmpty() ? new TextComponentTranslation("brokenwings.dropstatus." + messageRandom.nextInt(9), new Object[0]) : new TextComponentString(WingConfig.FIXED_MESSAGE);
                playerMP.func_146105_b((ITextComponent)msg, true);
            }
            if (WingConfig.SHOW_PARTICLES) {
                playerMP.func_71121_q().func_175739_a(EnumParticleTypes.TOTEM, playerMP.field_70165_t, playerMP.field_70163_u, playerMP.field_70161_v, 45, 0.0, 0.0, 0.0, 0.2, new int[0]);
            }
            if (WingConfig.PRINT_TO_LOG) {
                LOGGER.info("Dropped " + playerMP.func_70005_c_() + " out of the sky.");
                LOGGER.info("Dimension: " + playerMP.field_71093_bK);
                LOGGER.info("Position: " + BrokenWings.niceBlockPosToString(playerMP.func_180425_c()));
                for (ICountermeasure c3 : usedCountermeasures) {
                    LOGGER.info("Method: " + c3.getFriendlyName());
                }
            }
        }
    }

    private static boolean isPlayerImmune(EntityPlayerMP playerMP, List<ICountermeasure> countermeasures) {
        for (ItemStack armor : playerMP.func_184193_aE()) {
            if (armor.func_190926_b() || !WingConfig.WHITELIST_ARMOR_ITEMS.contains(armor, playerMP.field_71093_bK)) continue;
            return true;
        }
        for (ItemStack inv : playerMP.field_71071_by.field_70462_a) {
            if (inv.func_190926_b() || !WingConfig.WHITELIST_INVENTORY_ITEMS.contains(inv, playerMP.field_71093_bK)) continue;
            return true;
        }
        ItemStack off = playerMP.func_184592_cb();
        return !off.func_190926_b() && WingConfig.WHITELIST_INVENTORY_ITEMS.contains(off, playerMP.field_71093_bK);
    }

    private static String niceBlockPosToString(BlockPos pos) {
        return pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
    }
}

