/*
 * Decompiled with CFR 0.152.
 */
package quaternary.brokenwings.config;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.minecraftforge.common.config.Configuration;
import quaternary.brokenwings.BrokenWings;
import quaternary.brokenwings.config.ItemList;

public class ConfigHelpers {
    static <T extends Enum> T getEnum(Configuration config, String configName, String configCategory, T defaultValue, String configDescription, Function<T, String> describerFunction, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        String userProvidedString = config.getString(configName, configCategory, defaultValue.toString(), configDescription + "\n" + Arrays.stream(enumConstants).map(t -> "\"" + t.toString() + "\": " + (String)describerFunction.apply(t)).reduce((one, two) -> one + '\n' + two).get() + '\n', (String[])Arrays.stream(enumConstants).map(Enum::toString).toArray(String[]::new));
        Optional<Enum> userEnum = Arrays.stream(enumConstants).filter(t -> t.toString().equals(userProvidedString)).findAny();
        if (userEnum.isPresent()) {
            return (T)userEnum.get();
        }
        throw new IllegalArgumentException("\"" + userProvidedString + "\" is not a valid value for config option " + configName + "! See the config file for details");
    }

    static int[] getIntArray(Configuration config, String configName, String configCategory, int[] defaultsAsIntArray, String configComment) {
        ArrayList<String> defaultsAsStringList = new ArrayList<String>(defaultsAsIntArray.length);
        for (int d : defaultsAsIntArray) {
            defaultsAsStringList.add(String.valueOf(d));
        }
        String[] defaultsAsStringArray = defaultsAsStringList.toArray(new String[0]);
        String[] valuesAsStringArray = config.getStringList(configName, configCategory, defaultsAsStringArray, configComment);
        ArrayList<Integer> valuesAsIntList = new ArrayList<Integer>();
        for (String value : valuesAsStringArray) {
            String valueT = value.trim();
            try {
                valuesAsIntList.add(Integer.valueOf(valueT));
            }
            catch (NumberFormatException e) {
                BrokenWings.LOGGER.error("Can't make sense of '{}' as an integer", (Object)valueT);
                BrokenWings.LOGGER.error("Please fix the config value named {}", (Object)configName);
            }
        }
        return Ints.toArray(valuesAsIntList);
    }

    static ItemList getItemList(Configuration config, String configName, String configCategory, ItemList defaultEntries, String configComment) {
        String[] configEntry = config.getStringList(configName, configCategory, defaultEntries.toStringArray(), configComment + "\nSee readme on GitHub for examples of how to add extra metadata or dimension conditions");
        try {
            return new ItemList().addFromStringArray(configEntry);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problem parsing config entry '" + configName + "':", e);
        }
    }
}

