/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot;

import com.cazsius.solcarrot.tracking.CapabilityHandler;
import com.cazsius.solcarrot.tracking.FoodList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="solcarrot")
@Config(modid="solcarrot")
public final class SOLCarrotConfig {
    private static final String langPath = "config.solcarrot.";
    @Config.Name(value="defaultHeartCount")
    @Config.LangKey(value="config.solcarrot.base_hearts")
    @Config.Comment(value={"Number of hearts you start out with."})
    public static int baseHearts = 10;
    @Config.Name(value="heartsPerMilestone")
    @Config.LangKey(value="config.solcarrot.hearts_per_milestone")
    @Config.Comment(value={"Number of hearts you gain for reaching a new milestone."})
    public static int heartsPerMilestone = 2;
    @Config.Name(value="Milestone amounts")
    @Config.LangKey(value="config.solcarrot.milestones")
    @Config.Comment(value={"A list of numbers of unique foods you need to eat to unlock each milestone, in ascending order."})
    public static int[] milestones = new int[]{5, 10, 15, 20, 25};
    @Config.Name(value="isFoodTooltipEnabled")
    @Config.LangKey(value="config.solcarrot.is_food_tooltip_enabled")
    @Config.Comment(value={"If true, foods indicate in their tooltips whether or not they have been eaten."})
    public static boolean isFoodTooltipEnabled = true;
    @Config.Name(value="shouldShowProgressAboveHotbar")
    @Config.LangKey(value="config.solcarrot.should_show_progress_above_hotbar")
    @Config.Comment(value={"Whether the messages notifying you of reaching new milestones should be displayed above the hotbar or in chat."})
    public static boolean shouldShowProgressAboveHotbar = true;
    @Config.Name(value="Show Uneaten Foods")
    @Config.LangKey(value="config.solcarrot.should_show_uneaten_foods")
    @Config.Comment(value={"If true, the food book also lists foods that you haven't eaten, in addition to the ones you have."})
    public static boolean shouldShowUneatenFoods = true;
    @Config.Name(value="Enable Milestone Sounds")
    @Config.LangKey(value="config.solcarrot.should_play_milestone_sounds")
    @Config.Comment(value={"If true, reaching a new milestone plays a ding sound."})
    public static boolean shouldPlayMilestoneSounds = true;
    @Config.Name(value="Enable Intermediate Particles")
    @Config.LangKey(value="config.solcarrot.should_spawn_intermediate_particles")
    @Config.Comment(value={"If true, trying a new food spawns particles."})
    public static boolean shouldSpawnIntermediateParticles = true;
    @Config.Name(value="Enable Milestone Particles")
    @Config.LangKey(value="config.solcarrot.should_spawn_milestone_particles")
    @Config.Comment(value={"If true, reaching a new milestone spawns particles."})
    public static boolean shouldSpawnMilestoneParticles = true;
    @Config.Name(value="Food Blacklist")
    @Config.LangKey(value="config.solcarrot.food_blacklist")
    @Config.Comment(value={"Foods in this list won't affect the player's health nor show up in the food book."})
    public static String[] foodBlacklist = new String[0];
    @Config.Name(value="Food Whitelist")
    @Config.LangKey(value="config.solcarrot.food_whitelist")
    @Config.Comment(value={"When this list contains anything, the blacklist is ignored and instead only foods from here count."})
    public static String[] foodWhitelist = new String[0];
    @Config.Name(value="Minimum Food Value")
    @Config.LangKey(value="config.solcarrot.minimum_food_value")
    @Config.Comment(value={"The minimum hunger value foods need to provide in order to count for milestones, in half drumsticks."})
    public static int minimumFoodValue = 1;
    @Config.Name(value="Reset on Death")
    @Config.LangKey(value="config.solcarrot.reset_on_death")
    @Config.Comment(value={"Whether or not to reset the food list on death, effectively losing all bonus hearts."})
    public static boolean shouldResetOnDeath = false;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!event.getModID().equals("solcarrot")) {
            return;
        }
        ConfigManager.sync((String)"solcarrot", (Config.Type)Config.Type.INSTANCE);
        if (event.isWorldRunning()) {
            PlayerList players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            for (EntityPlayer player : players.func_181057_v()) {
                FoodList.get(player).updateProgressInfo();
                CapabilityHandler.syncFoodList(player);
            }
        }
    }

    private SOLCarrotConfig() {
    }
}

