/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.api.FoodCapability;
import com.cazsius.solcarrot.communication.MessageFoodList;
import com.cazsius.solcarrot.communication.PacketHandler;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.MaxHealthHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class CapabilityHandler {
    private static final ResourceLocation FOOD = SOLCarrot.resourceLocation("food");

    @SubscribeEvent
    public static void preInit(SOLCarrot.PreInitializationEvent e) {
        CapabilityManager.INSTANCE.register(FoodCapability.class, (Capability.IStorage)new FoodList.Storage(), FoodList::new);
    }

    @SubscribeEvent
    public static void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(FOOD, (ICapabilityProvider)new FoodList());
    }

    @SubscribeEvent
    public static void onPlayerLogin(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        CapabilityHandler.syncFoodList((EntityPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && SOLCarrotConfig.shouldResetOnDeath) {
            return;
        }
        FoodList original = FoodList.get(event.getOriginal());
        FoodList newInstance = FoodList.get(event.getEntityPlayer());
        newInstance.deserializeNBT(original.serializeNBT());
        CapabilityHandler.syncFoodList(event.getEntityPlayer());
    }

    public static void syncFoodList(EntityPlayer player) {
        FoodList foodList = FoodList.get(player);
        PacketHandler.channel.sendTo((IMessage)new MessageFoodList(foodList), (EntityPlayerMP)player);
        MaxHealthHandler.updateFoodHPModifier(player);
    }

    private CapabilityHandler() {
    }
}

