/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.CapabilityHandler;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.MaxHealthHandler;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.applecore.api.food.FoodEvent;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class FoodTracker {
    @SubscribeEvent
    public static void onFoodEaten(FoodEvent.FoodEaten event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        WorldServer world = (WorldServer)event.player.field_70170_p;
        EntityPlayer player = event.player;
        FoodList foodList = FoodList.get(player);
        boolean hasTriedNewFood = foodList.addFood(event.food);
        boolean newMilestoneReached = MaxHealthHandler.updateFoodHPModifier(player);
        CapabilityHandler.syncFoodList(player);
        ProgressInfo progressInfo = foodList.getProgressInfo();
        if (newMilestoneReached) {
            if (SOLCarrotConfig.shouldPlayMilestoneSounds) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (SOLCarrotConfig.shouldSpawnMilestoneParticles) {
                FoodTracker.spawnParticles(world, player, EnumParticleTypes.HEART, 12);
                if (progressInfo.hasReachedMax()) {
                    FoodTracker.spawnParticles(world, player, EnumParticleTypes.VILLAGER_HAPPY, 16);
                }
            }
            ITextComponent heartsDescription = Localization.localizedQuantityComponent("message", "hearts", SOLCarrotConfig.heartsPerMilestone);
            if (SOLCarrotConfig.shouldShowProgressAboveHotbar) {
                String messageKey = progressInfo.hasReachedMax() ? "finished.hotbar" : "milestone_achieved";
                player.func_146105_b(Localization.localizedComponent("message", messageKey, heartsDescription), true);
            } else {
                FoodTracker.showChatMessage(player, TextFormatting.DARK_AQUA, Localization.localizedComponent("message", "milestone_achieved", heartsDescription));
                if (progressInfo.hasReachedMax()) {
                    FoodTracker.showChatMessage(player, TextFormatting.GOLD, Localization.localizedComponent("message", "finished.chat", new Object[0]));
                }
            }
        } else if (hasTriedNewFood && SOLCarrotConfig.shouldSpawnIntermediateParticles) {
            FoodTracker.spawnParticles(world, player, EnumParticleTypes.END_ROD, 12);
        }
    }

    private static void spawnParticles(WorldServer world, EntityPlayer player, EnumParticleTypes type, int count) {
        world.func_175739_a(type, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, count, 0.5, 0.5, 0.5, 0.0, new int[0]);
    }

    private static void showChatMessage(EntityPlayer player, TextFormatting color, ITextComponent message) {
        ITextComponent component = Localization.localizedComponent("message", "chat_wrapper", message);
        component.func_150255_a(new Style().func_150238_a(color));
        player.func_146105_b(component, false);
    }

    private FoodTracker() {
    }
}

