/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.immersivecables.block;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockConnectable
extends BlockDirectional {
    protected BlockConnectable(Material materialIn) {
        super(materialIn);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) != null) {
            ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC((Object)tile), worldIn, new TargetingInfo(EnumFacing.UP, 0.0f, 0.0f, 0.0f));
            IESaveData.setDirty((int)worldIn.field_73011_w.getDimension());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta).func_177226_a((IProperty)field_176387_N, (Comparable)facing);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC((Object)tile), world, new TargetingInfo(EnumFacing.UP, 0.0f, 0.0f, 0.0f));
                IESaveData.setDirty((int)world.field_73011_w.getDimension());
                tile.func_145843_s();
            }
            return super.rotateBlock(world, pos, axis);
        }
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isPistonExtending) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IAdvancedSelectionBounds) {
            ((IEBlockInterfaces.IAdvancedSelectionBounds)tile).getAdvancedSelectionBounds().forEach(aabb -> {
                if (entityBox.func_72326_a(aabb)) {
                    collidingBoxes.add((AxisAlignedBB)aabb);
                }
            });
        } else {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn, isPistonExtending);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IAdvancedSelectionBounds) {
            RayTraceResult closestRT = null;
            for (AxisAlignedBB aabb : ((IEBlockInterfaces.IAdvancedSelectionBounds)tile).getAdvancedSelectionBounds()) {
                double distance;
                RayTraceResult rt = this.func_185503_a(pos, start, end, aabb.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())));
                double d = distance = closestRT == null || rt == null ? 0.0 : closestRT.field_72307_f.func_189985_c() - rt.field_72307_f.func_189985_c();
                if (rt == null) continue;
                if (closestRT != null) {
                    double d2 = start.func_189985_c() > end.func_189985_c() ? -1.0 : 1.0;
                    if (!(d2 * distance > 0.0)) continue;
                }
                closestRT = rt;
            }
            return closestRT;
        }
        return null;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (world.func_175623_d(pos.func_177972_a(BlockConnectable.getFacing(world, pos).func_176734_d())) && world instanceof World) {
            ((World)world).func_175655_b(pos, true);
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChange((IBlockAccess)worldIn, pos, fromPos);
    }

    private static EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return !world.func_175623_d(pos) ? (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockDirectional.field_176387_N) : EnumFacing.UP;
    }

    public static List<AxisAlignedBB> getTransformerBB(EnumFacing facing, BlockPos pos) {
        switch (facing) {
            case UP: {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0).func_186670_a(pos), new AxisAlignedBB(0.3125, 0.5625, 0.3125, 0.6875, 1.0, 0.6875).func_186670_a(pos));
            }
            case DOWN: {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.4375, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos), new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.4375, 0.6875).func_186670_a(pos));
            }
            case NORTH: {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 1.0).func_186670_a(pos), new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.4375).func_186670_a(pos));
            }
            case SOUTH: {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5625).func_186670_a(pos), new AxisAlignedBB(0.3125, 0.3125, 0.5625, 0.6875, 0.6875, 1.0).func_186670_a(pos));
            }
            case EAST: {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 1.0).func_186670_a(pos), new AxisAlignedBB(0.5625, 0.3125, 0.3125, 1.0, 0.6875, 0.6875).func_186670_a(pos));
            }
            case WEST: {
                return Arrays.asList(new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos), new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.4375, 0.6875, 0.6875).func_186670_a(pos));
            }
        }
        return null;
    }
}

