/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.immersivecables.wire;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.sanandrew.mods.immersivecables.util.ICConstants;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public class WireColors {
    private static final ResourceLocation RES_LOC = new ResourceLocation("immersivecables", "wire_colors.json");
    public static int ae2FluixWireColor = 13802495;
    public static int ae2DenseWireColor = 9199791;
    public static int ae2QuartzWireColor = 15262427;
    public static int rsWireColor = 7849727;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @SideOnly(value=Side.CLIENT)
    public static void initialize(IResourceManager mgr) {
        try (IResource res = mgr.func_110536_a(RES_LOC);
             InputStream stream = res.func_110527_b();){
            String json = IOUtils.toString((InputStream)stream, (Charset)Charset.forName("UTF-8"));
            WireColorsJson wcj = (WireColorsJson)GSON.fromJson(json, WireColorsJson.class);
            ae2FluixWireColor = Integer.decode(wcj.ae2FluixWireColor);
            ae2DenseWireColor = Integer.decode(wcj.ae2DenseWireColor);
            ae2QuartzWireColor = Integer.decode(wcj.ae2QuartzWireColor);
            rsWireColor = Integer.decode(wcj.rsWireColor);
        }
        catch (IOException | NumberFormatException ex) {
            ICConstants.LOG.log(Level.WARN, "Cannot load wire colors! Reverting to defaults.", (Throwable)ex);
            ae2FluixWireColor = 13802495;
            ae2DenseWireColor = 9199791;
            ae2QuartzWireColor = 15262427;
            rsWireColor = 7849727;
        }
    }

    private static class WireColorsJson {
        public String ae2FluixWireColor;
        public String ae2DenseWireColor;
        public String ae2QuartzWireColor;
        public String rsWireColor;

        private WireColorsJson() {
        }
    }
}

