/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class FieldRedirectTransformer
implements IClassTransformer {
    private final String clsName;
    private final String TYPE;
    private final String DESC;
    private final String bypass;

    protected FieldRedirectTransformer(String cls, String type, String bypass) {
        this.clsName = cls;
        this.TYPE = type;
        this.DESC = "()" + type;
        this.bypass = bypass;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!this.clsName.equals(transformedName)) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        Object fieldRef = null;
        for (Object f : classNode.fields) {
            if (this.TYPE.equals(((FieldNode)f).desc) && fieldRef == null) {
                fieldRef = f;
                continue;
            }
            if (!this.TYPE.equals(((FieldNode)f).desc)) continue;
            throw new RuntimeException("Error processing " + this.clsName + " - found a duplicate holder field");
        }
        if (fieldRef == null) {
            throw new RuntimeException("Error processing " + this.clsName + " - no holder field declared (is the code somehow obfuscated?)");
        }
        MethodNode getMethod = null;
        for (MethodNode m : classNode.methods) {
            if (m.name.equals(this.bypass)) continue;
            if (this.DESC.equals(m.desc) && getMethod == null) {
                getMethod = m;
                continue;
            }
            if (!this.DESC.equals(m.desc)) continue;
            throw new RuntimeException("Error processing " + this.clsName + " - duplicate get method found");
        }
        if (getMethod == null) {
            throw new RuntimeException("Error processing " + this.clsName + " - no get method found (is the code somehow obfuscated?)");
        }
        for (MethodNode m : classNode.methods) {
            if (m.name.equals(this.bypass)) continue;
            ListIterator it = m.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                if (insnNode.getType() != 4) continue;
                FieldInsnNode fi2 = (FieldInsnNode)insnNode;
                if (!((FieldNode)fieldRef).name.equals(fi2.name) || fi2.getOpcode() != 180) continue;
                it.remove();
                MethodInsnNode replace = new MethodInsnNode(182, classNode.name, getMethod.name, getMethod.desc, false);
                it.add(replace);
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

