/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.Config;

import com.google.common.base.Strings;
import com.wuest.from_the_depths.Base.BaseConfig;
import com.wuest.from_the_depths.EntityInfo.BossAddInfo;
import com.wuest.from_the_depths.EntityInfo.SpawnInfo;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class ConfigTileEntityAltarOfSpawning
extends BaseConfig {
    public BlockPos pos;
    public SpawnInfo currentSpawnInfo;
    public boolean bossSpawned;
    public int totalLightningBolts;
    public int ticksUntilNextLightningBolt;
    public ArrayList<BossAddInfo> preBossMinions;

    public ConfigTileEntityAltarOfSpawning() {
        this.Initialize();
    }

    @Override
    public void WriteToNBTCompound(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
        if (this.currentSpawnInfo != null && this.currentSpawnInfo.bossInfo != null && !Strings.isNullOrEmpty((String)this.currentSpawnInfo.key)) {
            NBTTagCompound spawnInfo = new NBTTagCompound();
            this.currentSpawnInfo.writeToNBT(spawnInfo);
            tag.func_74782_a("spawnInfo", (NBTBase)spawnInfo);
            tag.func_74757_a("bossSpawned", this.bossSpawned);
            tag.func_74768_a("totalLightningBolts", this.totalLightningBolts);
            tag.func_74768_a("ticksUntilNextLightningBolt", this.ticksUntilNextLightningBolt);
            NBTTagList tagList = new NBTTagList();
            if (!this.preBossMinions.isEmpty()) {
                for (BossAddInfo bossAddInfo : this.preBossMinions) {
                    NBTTagCompound addTagCompound = new NBTTagCompound();
                    bossAddInfo.writeToNBT(addTagCompound);
                    tagList.func_74742_a((NBTBase)addTagCompound);
                }
            }
            tag.func_74782_a("preBossMinions", (NBTBase)tagList);
        }
        compound.func_74782_a("configTag", (NBTBase)tag);
    }

    public ConfigTileEntityAltarOfSpawning ReadFromNBTTagCompound(NBTTagCompound compound) {
        ConfigTileEntityAltarOfSpawning config = new ConfigTileEntityAltarOfSpawning();
        if (compound.func_74764_b("configTag")) {
            NBTTagCompound tag = compound.func_74775_l("configTag");
            config.pos = NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l("pos"));
            if (tag.func_74764_b("spawnInfo")) {
                SpawnInfo spawnInfo = new SpawnInfo();
                config.currentSpawnInfo = spawnInfo.loadFromNBTData(tag.func_74775_l("spawnInfo"));
                if (Strings.isNullOrEmpty((String)config.currentSpawnInfo.key)) {
                    config.currentSpawnInfo = null;
                }
                config.bossSpawned = tag.func_74767_n("bossSpawned");
                config.totalLightningBolts = tag.func_74762_e("totalLightningBolts");
                config.ticksUntilNextLightningBolt = tag.func_74762_e("ticksUntilNextLightningBolt");
                NBTTagList preBossMinionTagList = tag.func_150295_c("preBossMinions", 10);
                if (!preBossMinionTagList.func_82582_d()) {
                    for (int i = 0; i < preBossMinionTagList.func_74745_c(); ++i) {
                        NBTTagCompound bossAddInfoCompound = preBossMinionTagList.func_150305_b(i);
                        BossAddInfo bossAddInfo = new BossAddInfo();
                        this.preBossMinions.add(bossAddInfo.loadFromNBTData(bossAddInfoCompound));
                    }
                }
            }
        }
        return config;
    }

    public void Initialize() {
        this.pos = new BlockPos(0, 0, 0);
        this.preBossMinions = new ArrayList();
        this.currentSpawnInfo = null;
    }
}

