/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.Config;

import com.wuest.from_the_depths.FromTheDepths;
import com.wuest.from_the_depths.Proxy.CommonProxy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;

public class ModConfiguration {
    public static String OPTIONS = "general.options";
    public static String RecipeOptions = "general.options.recipes";
    public static String tagKey = "FromTheDepthsConfig";
    private static String allowAltarToBeDestroyedName = "Allow Altar to be Destroyed";
    public boolean enableStructurePreview;
    public boolean allowAltarToBeDestroyed;
    public HashMap<String, Boolean> recipeConfiguration = new HashMap();
    public static String arenaStructureKey = "Arena";
    public static String[] recipeKeys = new String[]{arenaStructureKey};

    public static void syncConfig() {
        Configuration config = FromTheDepths.config;
        if (CommonProxy.proxyConfiguration == null) {
            CommonProxy.proxyConfiguration = new ModConfiguration();
        }
        CommonProxy.proxyConfiguration.allowAltarToBeDestroyed = config.getBoolean(allowAltarToBeDestroyedName, OPTIONS, false, "Determines if the Altar can be destroyed. server configuration overrides client.");
        for (String key : recipeKeys) {
            boolean value = config.getBoolean(key, RecipeOptions, true, "Determines if the recipe(s) associated with the " + key + " are enabled.");
            CommonProxy.proxyConfiguration.recipeConfiguration.put(key, value);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public NBTTagCompound ToNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(allowAltarToBeDestroyedName, this.allowAltarToBeDestroyed);
        for (Map.Entry<String, Boolean> entry : this.recipeConfiguration.entrySet()) {
            tag.func_74757_a(entry.getKey(), entry.getValue().booleanValue());
        }
        return tag;
    }

    public static ModConfiguration getFromNBTTagCompound(NBTTagCompound tag) {
        ModConfiguration config = new ModConfiguration();
        config.allowAltarToBeDestroyed = tag.func_74767_n(allowAltarToBeDestroyedName);
        for (String key : recipeKeys) {
            config.recipeConfiguration.put(key, tag.func_74767_n(key));
        }
        return config;
    }
}

