/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.EntityInfo;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.wuest.from_the_depths.EntityInfo.DropInfo;
import com.wuest.from_the_depths.FromTheDepths;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class BaseMonster {
    public String domain;
    public String name;
    public String displayName;
    public int maxHealth = -1;
    public float attackDamage = -1.0f;
    public boolean alwaysShowDisplayName = false;
    public int timeToWaitBeforeSpawn = 20;
    public ArrayList<DropInfo> additionalDrops = new ArrayList();
    public String commandToRunAtSpawn = "";
    public JsonObject nbt = null;

    public ResourceLocation createResourceLocation() {
        return new ResourceLocation(this.domain, this.name);
    }

    public Entity createEntityForWorld(World world, BlockPos pos, ICommandSender commandSender) {
        ResourceLocation resourceLocation = this.createResourceLocation();
        Entity entity = EntityList.func_188429_b((ResourceLocation)resourceLocation, (World)world);
        if (entity != null && entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)entity;
            BlockPos spawnPos = this.determineSpawnPos(pos, world, entityLiving.field_70131_O);
            if (spawnPos != null) {
                IAttributeInstance entityAttribute;
                if (this.maxHealth > 0) {
                    entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.maxHealth);
                    entityLiving.func_70606_j((float)this.maxHealth);
                }
                if (this.attackDamage > 0.0f && (entityAttribute = entityLiving.func_110148_a(SharedMonsterAttributes.field_111264_e)) != null) {
                    entityAttribute.func_111128_a((double)this.attackDamage);
                }
                if (this.displayName != null && !this.displayName.isEmpty() && !this.displayName.trim().isEmpty()) {
                    entityLiving.func_96094_a(this.displayName);
                    entityLiving.func_174805_g(this.alwaysShowDisplayName);
                }
                NBTTagCompound trackingTag = new NBTTagCompound();
                NBTTagList additionalDropList = new NBTTagList();
                if (!this.additionalDrops.isEmpty()) {
                    for (DropInfo dropInfo : this.additionalDrops) {
                        NBTTagCompound dropInfoTagCompound = new NBTTagCompound();
                        dropInfo.writeToNBT(dropInfoTagCompound);
                        additionalDropList.func_74742_a((NBTBase)dropInfoTagCompound);
                    }
                }
                trackingTag.func_74782_a("additionalDrops", (NBTBase)additionalDropList);
                NBTTagCompound entityCompoundTag = entityLiving.getEntityData();
                entityCompoundTag.func_74782_a("from_the_depths", (NBTBase)trackingTag);
                entityLiving.field_98038_p = true;
                entityLiving.field_70759_as = entityLiving.field_70177_z;
                entityLiving.field_70761_aq = entityLiving.field_70177_z;
                entityLiving.func_70634_a((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
                entityLiving.func_180482_a(world.func_175649_E(new BlockPos((Vec3i)spawnPos)), (IEntityLivingData)null);
                NBTTagCompound serializedEntity = entityLiving.serializeNBT();
                if (this.nbt != null) {
                    NBTTagCompound compound = null;
                    try {
                        compound = JsonToNBT.func_180713_a((String)this.nbt.toString());
                    }
                    catch (NBTException exception) {
                        FromTheDepths.logger.error((Object)exception);
                    }
                    if (compound != null && !compound.func_82582_d()) {
                        for (String tagKey : compound.func_150296_c()) {
                            serializedEntity.func_74782_a(tagKey, compound.func_74781_a(tagKey));
                        }
                        entityLiving = (EntityLiving)EntityList.func_75615_a((NBTTagCompound)serializedEntity, (World)world);
                    }
                }
                world.func_72838_d((Entity)entityLiving);
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), true));
                entityLiving.func_70642_aH();
                if (this.commandToRunAtSpawn != null && !this.commandToRunAtSpawn.isEmpty()) {
                    world.func_73046_m().func_71187_D().func_71556_a(commandSender, this.commandToRunAtSpawn);
                }
            }
        }
        return entity;
    }

    public BlockPos determineSpawnPos(BlockPos originalPos, World world, float height) {
        BlockPos spawnPos = null;
        for (int i = 0; i < 10; ++i) {
            int randomValue = BaseMonster.determineRandomInt(100, world) % 2 == 0 ? -1 : 1;
            int randomX = BaseMonster.determineRandomInt(6, world) * randomValue + randomValue * 2;
            randomValue = BaseMonster.determineRandomInt(100, world) % 2 == 0 ? -1 : 1;
            int randomZ = BaseMonster.determineRandomInt(6, world) * randomValue + randomValue * 2;
            spawnPos = new BlockPos(originalPos.func_177958_n() + randomX, originalPos.func_177981_b(1).func_177956_o(), originalPos.func_177952_p() + randomZ);
            if (world.func_175623_d(spawnPos)) {
                BlockPos tempPos;
                boolean enoughSpace = true;
                int j = 0;
                while ((float)j < height) {
                    if (!world.func_175623_d(spawnPos.func_177981_b(j))) {
                        enoughSpace = false;
                    }
                    ++j;
                }
                if (!enoughSpace) continue;
                while (world.func_175623_d(spawnPos) && world.func_175623_d(tempPos = spawnPos.func_177977_b())) {
                    spawnPos = spawnPos.func_177977_b();
                }
            } else {
                int count = 0;
                while (!world.func_175623_d(spawnPos)) {
                    spawnPos = spawnPos.func_177984_a();
                    if (++count < 20) continue;
                }
            }
            spawnPos = spawnPos.func_177984_a();
            return spawnPos;
        }
        return null;
    }

    public static int determineRandomInt(int bound, World world) {
        int randomCounter = world.field_73012_v.nextInt(21);
        int returnValue = 1;
        for (int i = 0; i < randomCounter; ++i) {
            returnValue = world.field_73012_v.nextInt(bound);
        }
        return returnValue;
    }

    public boolean isValidEntity(World world) {
        ResourceLocation resourceLocation = this.createResourceLocation();
        Entity entity = EntityList.func_188429_b((ResourceLocation)resourceLocation, (World)world);
        return entity != null && entity instanceof EntityLiving;
    }

    public NBTTagCompound createTag() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return tag;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("domain", this.domain);
        tag.func_74778_a("name", this.name);
        if (this.displayName != null && !this.displayName.trim().isEmpty()) {
            tag.func_74778_a("displayName", this.displayName);
        }
        tag.func_74768_a("maxHealth", this.maxHealth);
        tag.func_74776_a("attackDamage", this.attackDamage);
        tag.func_74757_a("alwaysShowDisplayName", this.alwaysShowDisplayName);
        tag.func_74768_a("timeToWaitBeforeSpawn", this.timeToWaitBeforeSpawn);
        tag.func_74778_a("commandToRunAtSpawn", this.commandToRunAtSpawn);
        if (this.nbt != null) {
            tag.func_74778_a("nbt", this.nbt.toString());
        }
        NBTTagList additionalDrops = new NBTTagList();
        if (this.additionalDrops != null) {
            for (DropInfo info : this.additionalDrops) {
                NBTTagCompound dropInfo = new NBTTagCompound();
                info.writeToNBT(dropInfo);
                additionalDrops.func_74742_a((NBTBase)dropInfo);
            }
            tag.func_74782_a("additionalDrops", (NBTBase)additionalDrops);
        }
    }

    public void loadFromNBT(NBTTagCompound tag) {
        this.domain = tag.func_74779_i("domain");
        this.name = tag.func_74779_i("name");
        this.displayName = tag.func_74779_i("displayName");
        this.maxHealth = tag.func_74762_e("maxHealth");
        this.attackDamage = tag.func_74760_g("attackDamage");
        this.alwaysShowDisplayName = tag.func_74767_n("alwaysShowDisplayName");
        this.timeToWaitBeforeSpawn = tag.func_74762_e("timeToWaitBeforeSpawn");
        this.commandToRunAtSpawn = tag.func_74779_i("commandToRunAtSpawn");
        if (tag.func_74764_b("nbt")) {
            JsonParser parser = new JsonParser();
            this.nbt = (JsonObject)parser.parse(tag.func_74779_i("nbt"));
        }
        if (tag.func_74764_b("additionalDrops")) {
            this.additionalDrops = new ArrayList();
            NBTTagList dropList = tag.func_150295_c("additionalDrops", 10);
            if (!dropList.func_82582_d()) {
                for (int i = 0; i < dropList.func_74745_c(); ++i) {
                    NBTTagCompound dropInfoTag = dropList.func_150305_b(i);
                    DropInfo dropInfo = new DropInfo();
                    dropInfo.loadFromNBTData(dropInfoTag);
                    if (dropInfo.item == null || dropInfo.item.isEmpty()) continue;
                    this.additionalDrops.add(dropInfo);
                }
            }
        }
    }
}

