/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.Items;

import com.google.common.base.Strings;
import com.wuest.from_the_depths.Config.ConfigTileEntityAltarOfSpawning;
import com.wuest.from_the_depths.EntityInfo.SpawnInfo;
import com.wuest.from_the_depths.ModRegistry;
import com.wuest.from_the_depths.TileEntities.TileEntityAltarOfSpawning;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class ItemTotemOfSpawning
extends Item {
    public String key = "";

    public ItemTotemOfSpawning(String key, String name) {
        this.key = key;
        this.func_77637_a(CreativeTabs.field_78035_l);
        if (key != null && !key.isEmpty()) {
            String registryName = name + "_" + key.toLowerCase().trim().replace(' ', '_').replace('-', '_').replace('\t', '_');
            ModRegistry.setItemName(this, registryName);
        } else {
            ModRegistry.setItemName(this, name);
        }
        this.func_77655_b("from_the_depths:" + name);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        return stack.func_77978_p();
    }

    public String func_77653_i(ItemStack stack) {
        SpawnInfo spawnInfo = this.getSpawnInfoFromItemStack(stack);
        if (spawnInfo != null) {
            String value = ("" + I18n.func_74838_a((String)this.func_77657_g(stack))).trim() + " (" + spawnInfo.key + ")";
            return value;
        }
        return ("" + I18n.func_74838_a((String)this.func_77657_g(stack))).trim() + " (Does Nothing. Do not use.)";
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                TileEntity tileEntity = worldIn.func_175625_s(pos);
                if (tileEntity instanceof TileEntityAltarOfSpawning) {
                    TileEntityAltarOfSpawning tileEntityAltarOfSpawning = (TileEntityAltarOfSpawning)tileEntity;
                    ItemStack heldStack = player.func_184586_b(hand);
                    if (((ConfigTileEntityAltarOfSpawning)tileEntityAltarOfSpawning.getConfig()).currentSpawnInfo != null && !Strings.isNullOrEmpty((String)((ConfigTileEntityAltarOfSpawning)tileEntityAltarOfSpawning.getConfig()).currentSpawnInfo.key)) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Cannot spawn a monster at this time as additional monsters are going to be spawned. Please wait for all minions to be spawned."));
                    } else {
                        ItemTotemOfSpawning totemOfSpawning = (ItemTotemOfSpawning)heldStack.func_77973_b();
                        SpawnInfo spawnInfo = totemOfSpawning.getSpawnInfoFromItemStack(heldStack);
                        if (spawnInfo != null) {
                            if (spawnInfo.bossInfo.isValidEntity(worldIn)) {
                                if (heldStack.func_190916_E() == 1) {
                                    player.field_71071_by.func_184437_d(heldStack);
                                } else {
                                    heldStack.func_190918_g(1);
                                }
                                player.field_71069_bz.func_75142_b();
                                tileEntityAltarOfSpawning.InitiateSpawning(spawnInfo.clone(), 20, worldIn);
                                return EnumActionResult.SUCCESS;
                            }
                            player.func_145747_a((ITextComponent)new TextComponentString("Entity with name of [" + spawnInfo.bossInfo.name + "] and mod of [" + spawnInfo.bossInfo.domain + "] was not found."));
                        }
                    }
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("The current world difficulty is set to Peaceful. Unable to summon boss or minions."));
            }
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldStack = playerIn.func_184586_b(handIn);
        SpawnInfo info = this.getSpawnInfoFromItemStack(heldStack);
        if (info != null) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)heldStack);
    }

    public SpawnInfo getSpawnInfoFromItemStack(ItemStack stack) {
        NBTTagCompound tagCompound = this.getNBTShareTag(stack);
        String spawn_info = tagCompound.func_74779_i("spawn_info");
        if (spawn_info == null || spawn_info.isEmpty()) {
            spawn_info = ((ItemTotemOfSpawning)stack.func_77973_b()).key;
        }
        return this.getSpawnInfoFromKey(spawn_info);
    }

    public SpawnInfo getSpawnInfoFromKey(String key) {
        if (ModRegistry.SpawnInfosAndItems.containsKey(key)) {
            Tuple<SpawnInfo, ItemTotemOfSpawning> tuple = ModRegistry.SpawnInfosAndItems.get(key);
            return (SpawnInfo)tuple.func_76341_a();
        }
        return null;
    }
}

