/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wuest.from_the_depths.Blocks.BlockAltarOfSpawning;
import com.wuest.from_the_depths.EntityInfo.SpawnInfo;
import com.wuest.from_the_depths.FromTheDepths;
import com.wuest.from_the_depths.Items.ItemTotemOfSpawning;
import com.wuest.from_the_depths.Proxy.Messages.ConfigSyncMessage;
import com.wuest.from_the_depths.Proxy.Messages.Handlers.ConfigSyncHandler;
import com.wuest.from_the_depths.TileEntities.TileEntityAltarOfSpawning;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModRegistry {
    public static ArrayList<Item> ModItems = new ArrayList();
    public static ArrayList<Block> ModBlocks = new ArrayList();
    public static ArrayList<SpawnInfo> SpawnInfos = new ArrayList();
    public static HashMap<Integer, Class> ModGuis = new HashMap();
    public static HashMap<String, Tuple<SpawnInfo, ItemTotemOfSpawning>> SpawnInfosAndItems = new HashMap();
    public static final int GuiChickenCoop = 1;

    public static ItemTotemOfSpawning TotemOfSpawning() {
        return ModRegistry.GetItem(ItemTotemOfSpawning.class);
    }

    public static BlockAltarOfSpawning AlterOfSpawning() {
        return ModRegistry.GetBlock(BlockAltarOfSpawning.class);
    }

    public static <T extends Item> T GetItem(Class<T> genericClass) {
        for (Item entry : ModItems) {
            if (entry.getClass() != genericClass) continue;
            return (T)entry;
        }
        return null;
    }

    public static <T extends Block> T GetBlock(Class<T> genericClass) {
        for (Block entry : ModBlocks) {
            if (entry.getClass() != genericClass) continue;
            return (T)entry;
        }
        return null;
    }

    public static GuiScreen GetModGuiByID(int id, int x, int y, int z) {
        for (Map.Entry<Integer, Class> entry : ModGuis.entrySet()) {
            if (entry.getKey() != id) continue;
            try {
                return (GuiScreen)entry.getValue().getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(x, y, z);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void RegisterModComponents() {
        try {
            BlockAltarOfSpawning block = new BlockAltarOfSpawning("block_altar_of_summoning");
            ModRegistry.registerBlock(block);
        }
        catch (Exception ex) {
            FMLLog.getLogger().warn(ex.getMessage());
        }
        ItemTotemOfSpawning baseTotem = new ItemTotemOfSpawning(null, "item_totem_of_summoning");
        ModRegistry.registerItem(baseTotem);
        GameRegistry.registerTileEntity(TileEntityAltarOfSpawning.class, (String)"from_the_depths:block_altar_of_summoning");
        for (SpawnInfo spawnInfo : SpawnInfos) {
            ItemTotemOfSpawning registeredItem = new ItemTotemOfSpawning(spawnInfo.key, "item_totem_of_summoning");
            ModRegistry.registerItem(registeredItem);
            SpawnInfosAndItems.put(spawnInfo.key, (Tuple<SpawnInfo, ItemTotemOfSpawning>)new Tuple((Object)spawnInfo, (Object)registeredItem));
        }
    }

    public static void RegisterOreDictionaryRecords() {
    }

    public static void RegisterMessages() {
        FromTheDepths.network.registerMessage(ConfigSyncHandler.class, ConfigSyncMessage.class, 1, Side.CLIENT);
    }

    public static void RegisterCapabilities() {
    }

    public static void RegisterSpawningInfo() {
        File[] childFiles;
        Gson GSON = new GsonBuilder().create();
        if (!(FromTheDepths.proxy.modDirectory == null && FromTheDepths.proxy.modDirectory.toFile().exists() || (childFiles = FromTheDepths.proxy.modDirectory.toFile().listFiles()) == null || childFiles.length <= 0)) {
            for (File file : childFiles) {
                if (!file.isFile()) continue;
                Path path = file.toPath();
                try {
                    String fileContents = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
                    SpawnInfos.add((SpawnInfo)GSON.fromJson(fileContents, SpawnInfo.class));
                }
                catch (JsonParseException e) {
                    FromTheDepths.logger.error("From_The_Depths: Parsing error loading spawn information: {}. {}", (Object)path.toString(), (Object)e);
                }
                catch (Exception e) {
                    FromTheDepths.logger.error("From_The_Depths: Error loading spawn information {}. {}", (Object)path.toString(), (Object)e);
                }
            }
        }
    }

    public static void RegisterTotemOfSummoningRecipes() {
        if (FromTheDepths.proxy.modDirectory.toFile().exists()) {
            JsonContext ctx = new JsonContext("from_the_depths");
            Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
            boolean loadedRecipe = false;
            for (File file : FromTheDepths.proxy.modDirectory.toFile().listFiles()) {
                if (!file.isFile()) continue;
                Path path = file.toPath();
                String name = Files.getNameWithoutExtension((String)file.getName()).toLowerCase().replace(' ', '_').replace('-', '_').replace('\t', '_');
                ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
                try {
                    String fileContents = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
                    JsonObject json = (JsonObject)JsonUtils.func_193837_a((Gson)GSON, (String)fileContents, JsonObject.class, (boolean)true);
                    if (!json.has("recipe")) continue;
                    JsonObject recipeObject = json.getAsJsonObject("recipe");
                    String informationKey = json.get("key").getAsString();
                    if (SpawnInfosAndItems.containsKey(informationKey)) {
                        Tuple<SpawnInfo, ItemTotemOfSpawning> registeredLink = SpawnInfosAndItems.get(informationKey);
                        IRecipe recipe = CraftingHelper.getRecipe((JsonObject)recipeObject, (JsonContext)ctx);
                        ItemStack recipeOutput = recipe.func_77571_b();
                        if (!(recipeOutput.func_77973_b() instanceof ItemTotemOfSpawning)) continue;
                        recipeOutput.func_77973_b().getNBTShareTag(recipeOutput);
                        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe.setRegistryName(key));
                        loadedRecipe = true;
                        continue;
                    }
                    FromTheDepths.logger.warn("There is no recipe information for file: {}. This boss will not be able to be spawned unless a recipe is registered through other means.", (Object)path.toString());
                }
                catch (JsonParseException e) {
                    FromTheDepths.logger.error("From_The_Depths: Parsing error loading recipe {}. {}", (Object)key, (Object)e);
                }
                catch (Exception e) {
                    FromTheDepths.logger.error("From_The_Depths: Error loading recipe {}. {}", (Object)key, (Object)e);
                }
            }
            if (loadedRecipe) {
                FMLCommonHandler.instance().resetClientRecipeBook();
            }
        }
    }

    public static <T extends Item> T registerItem(T item) {
        ModItems.add(item);
        return item;
    }

    public static <T extends Block> T registerBlock(T block) {
        return ModRegistry.registerBlock(block, true);
    }

    public static <T extends Block> T registerBlock(T block, boolean includeItemBlock) {
        if (includeItemBlock) {
            ModItems.add((Item)new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }
        ModBlocks.add(block);
        return block;
    }

    public static <T extends Block, I extends ItemBlock> T registerBlock(T block, I itemBlock) {
        ModBlocks.add(block);
        if (itemBlock != null) {
            ModItems.add((Item)itemBlock);
        }
        return block;
    }

    public static void setItemName(Item item, String itemName) {
        if (itemName != null) {
            item.setRegistryName("from_the_depths:" + itemName);
            item.func_77655_b(item.getRegistryName().toString());
        }
    }

    public static void setBlockName(Block block, String blockName) {
        block.setRegistryName(blockName);
        block.func_149663_c(block.getRegistryName().toString());
    }

    public static void AddGuis() {
    }

    public static ShapedRecipes AddShapedRecipe(String name, String groupName, ItemStack stack, Object ... recipeComponents) {
        name = "from_the_depths".toLowerCase().replace(' ', '_') + ":" + name;
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])recipeComponents);
        ShapedRecipes shapedrecipes = new ShapedRecipes(groupName, primer.width, primer.height, primer.input, stack);
        shapedrecipes.setRegistryName(name);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapedrecipes);
        return shapedrecipes;
    }

    public static ShapelessRecipes AddShapelessRecipe(String name, String groupName, ItemStack stack, Object ... recipeComponents) {
        name = "from_the_depths".toLowerCase().replace(' ', '_') + ":" + name;
        NonNullList list = NonNullList.func_191196_a();
        for (Object object : recipeComponents) {
            if (object instanceof ItemStack) {
                list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)object).func_77946_l()}));
                continue;
            }
            if (object instanceof Item) {
                list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)object)}));
                continue;
            }
            if (!(object instanceof Block)) {
                throw new IllegalArgumentException("Invalid shapeless recipe: unknown type " + object.getClass().getName() + "!");
            }
            list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)object)}));
        }
        ShapelessRecipes shapelessRecipes = new ShapelessRecipes(groupName, stack, list);
        shapelessRecipes.setRegistryName(name);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapelessRecipes);
        return shapelessRecipes;
    }
}

