/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.core.tiles.connections.data.network;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ISonarListener;
import sonar.logistics.api.core.tiles.connections.data.network.INetworkItemHandler;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.api.core.tiles.readers.channels.INetworkChannels;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.base.utils.CacheType;
import sonar.logistics.core.tiles.connections.data.network.CacheHandler;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredBlockCoords;
import sonar.logistics.core.tiles.displays.info.types.general.InfoChangeableList;

public interface ILogisticsNetwork
extends ISonarListener,
ISonarListenable<ILogisticsNetwork> {
    public static final int CONNECTED_NETWORK = 0;
    public static final int WATCHING_NETWORK = 1;

    public int getNetworkID();

    public void onNetworkCreated();

    public void onNetworkTick();

    public void onNetworkRemoved();

    public boolean validateTile(INetworkTile var1);

    public void addConnection(INetworkTile var1);

    public void removeConnection(INetworkTile var1);

    public void addLocalInfoProvider(IInfoProvider var1);

    public void removeLocalInfoProvider(IInfoProvider var1);

    public void sendConnectionsPacket(EntityPlayer var1);

    public List<NodeConnection> getConnections(CacheType var1);

    public InfoChangeableList<MonitoredBlockCoords> createConnectionsList(CacheType var1);

    public <T extends INetworkTile> List<T> getCachedTiles(CacheHandler<T> var1, CacheType var2);

    @Nullable
    public <T extends INetworkChannels> T getNetworkChannels(Class<T> var1);

    public <T extends INetworkChannels> T getOrCreateNetworkChannels(Class<T> var1);

    public List<IInfoProvider> getLocalInfoProviders();

    public List<IInfoProvider> getGlobalInfoProviders();

    public INetworkItemHandler getNetworkItemHandler();

    default public long getNetworkTickTime() {
        return 0L;
    }
}

