/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.core.tiles.wireless.receivers;

import java.util.UUID;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessConnectionState;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessSecurity;
import sonar.logistics.api.core.tiles.wireless.emitters.IWirelessEmitter;
import sonar.logistics.base.tiles.INetworkTile;

public interface IWirelessReceiver<E extends IWirelessEmitter>
extends INetworkTile {
    public UUID getOwner();

    public void onEmitterSecurityChanged(E var1, EnumWirelessSecurity var2);

    public void onEmitterDisconnected(E var1);

    public void onEmitterConnected(E var1);

    public EnumWirelessConnectionState canEmitterAccessReceiver(E var1);

    default public EnumWirelessConnectionState canReceiverAccessEmitter(E emitter, EnumWirelessSecurity emitterSecurity) {
        if (emitterSecurity.requiresPermission()) {
            return emitter.canPlayerConnect(this.getOwner());
        }
        return EnumWirelessConnectionState.CONNECTED;
    }

    default public EnumWirelessConnectionState canAccess(E emitter) {
        return EnumWirelessConnectionState.isConnected(this.canEmitterAccessReceiver(emitter), this.canReceiverAccessEmitter(emitter, emitter.getSecurity()));
    }
}

