/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.helpers.FunctionHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.PlayerListener;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.CommonInfoHandler;
import sonar.logistics.base.guidance.errors.IInfoError;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.base.listeners.PL2ListenerList;
import sonar.logistics.base.utils.worlddata.ConnectedDisplayData;
import sonar.logistics.base.utils.worlddata.GSIData;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayGSISaveHandler;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;
import sonar.logistics.core.tiles.displays.info.types.InfoError;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;

public class ServerInfoHandler
extends CommonInfoHandler {
    private int IDENTITY_COUNT;
    public Map<ILogicListenable, List<Integer>> changedInfo = new HashMap<ILogicListenable, List<Integer>>();
    private List<IInfoError> added_errors = new ArrayList<IInfoError>();

    public static ServerInfoHandler instance() {
        return PL2.proxy.getServerManager();
    }

    public ServerInfoHandler() {
        super(Side.SERVER);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.IDENTITY_COUNT = 0;
        this.changedInfo.clear();
        GSIData.unloadedGSI.clear();
        ConnectedDisplayData.unloadedDisplays.clear();
    }

    public int setIdentityCount(int count) {
        this.IDENTITY_COUNT = count;
        return this.IDENTITY_COUNT;
    }

    public int getNextIdentity() {
        return this.IDENTITY_COUNT++;
    }

    public int getIdentityCount() {
        return this.IDENTITY_COUNT;
    }

    public void sendInfoUpdates() {
        if (!this.changedInfo.isEmpty() && !this.gsiMap.isEmpty()) {
            HashMap<EntityPlayerMP, NBTTagList> savePackets = new HashMap<EntityPlayerMP, NBTTagList>();
            for (Map.Entry<ILogicListenable, List<Integer>> id : this.changedInfo.entrySet()) {
                PL2ListenerList list = id.getKey().getListenerList();
                List<PlayerListener> listeners = list.getAllListeners(ListenerType.OLD_GUI_LISTENER, ListenerType.OLD_DISPLAY_LISTENER);
                if (listeners.isEmpty()) continue;
                for (Integer i : id.getValue()) {
                    NBTTagCompound saveTag;
                    InfoUUID uuid = new InfoUUID(id.getKey().getIdentity(), (int)i);
                    IInfo monitorInfo = (IInfo)this.infoMap.get(uuid);
                    if (monitorInfo == null || (saveTag = InfoHelper.writeInfoToNBT(new NBTTagCompound(), monitorInfo, NBTHelper.SyncType.SAVE)).func_82582_d()) continue;
                    saveTag = uuid.writeData(saveTag, NBTHelper.SyncType.SAVE);
                    InfoPacketHelper.createInfoUpdatesForListeners(savePackets, listeners, saveTag, saveTag, true);
                }
            }
            if (!savePackets.isEmpty()) {
                savePackets.forEach((key, value) -> InfoPacketHelper.sendInfoUpdatePacket(key, value, NBTHelper.SyncType.SAVE));
                this.changedInfo.clear();
            }
        }
    }

    public void changeInfo(ILogicListenable source, InfoUUID id, IInfo info) {
        if (!InfoUUID.valid(id)) {
            return;
        }
        info = info == null ? InfoError.noData : info;
        IInfo last = this.infoMap.computeIfAbsent(id, I -> InfoError.noData);
        if (InfoHelper.hasInfoChanged(last, info)) {
            this.setInfo(id, info);
            info.onInfoStored();
            this.markChanged(source, id);
        }
    }

    public void markChanged(ILogicListenable source, InfoUUID ... infoUUIDs) {
        for (InfoUUID id : infoUUIDs) {
            List<Integer> changes = this.changedInfo.computeIfAbsent(source, FunctionHelper.ARRAY);
            if (changes.contains(id.channelID)) continue;
            changes.add(id.channelID);
        }
    }

    public void addError(IInfoError error) {
        this.added_errors.add(error);
    }

    public void addErrors(List<IInfoError> errors) {
        this.added_errors.addAll(errors);
    }

    public void sendErrors() {
        if (this.added_errors.isEmpty()) {
            return;
        }
        HashMap affectedGSIs = new HashMap();
        for (IInfoError iInfoError : this.added_errors) {
            block1: for (DisplayGSI gsi : this.gsiMap.values()) {
                for (InfoUUID uuid : iInfoError.getAffectedUUIDs()) {
                    if (!gsi.isDisplayingUUID(uuid)) continue;
                    affectedGSIs.computeIfAbsent(gsi, FunctionHelper.ARRAY);
                    ((List)affectedGSIs.get((Object)gsi)).add(iInfoError);
                    continue block1;
                }
            }
        }
        for (Map.Entry entry : affectedGSIs.entrySet()) {
            ((DisplayGSI)((Object)entry.getKey())).addInfoErrors((List)entry.getValue());
            ((DisplayGSI)((Object)entry.getKey())).sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ERRORS);
        }
    }
}

