/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.channels;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.ChannelType;
import sonar.logistics.base.channels.EntityConnection;
import sonar.logistics.base.channels.NodeConnection;

public class ChannelList
implements ISyncPart {
    public List<BlockCoords> coordList = new ArrayList<BlockCoords>();
    public List<UUID> uuidList = new ArrayList<UUID>();
    public int identity;
    public final int tagID;
    public ISyncableListener listener;
    public ChannelType type;

    public ChannelList(int identity, ChannelType type, int tagID) {
        this.type = type;
        this.tagID = tagID;
        this.identity = identity;
    }

    public ChannelList setListener(ISyncableListener listener) {
        this.listener = listener;
        return this;
    }

    public int getIdentity() {
        return this.identity;
    }

    public boolean equals(Object object) {
        return object instanceof ChannelList ? ((ChannelList)object).identity == this.identity : this.coordList.equals(object);
    }

    public void give(BlockCoords coords) {
        if (coords != null) {
            if (!coords.contains(this.coordList)) {
                if (this.type == ChannelType.SINGLE) {
                    this.coordList.clear();
                    this.uuidList.clear();
                }
                this.add(coords);
            } else {
                if (this.type == ChannelType.SINGLE) {
                    this.coordList.clear();
                    this.uuidList.clear();
                } else {
                    Iterator<BlockCoords> iterator = this.coordList.iterator();
                    this.coordList.removeIf(coord -> coord.equals((Object)coords));
                }
                this.markDirty();
            }
        }
    }

    public void give(UUID newUUID) {
        if (newUUID != null) {
            if (!this.uuidList.contains(newUUID)) {
                if (this.type == ChannelType.SINGLE) {
                    this.coordList.clear();
                    this.uuidList.clear();
                }
                this.addUUID(newUUID);
            } else {
                if (this.type == ChannelType.SINGLE) {
                    this.coordList.clear();
                    this.uuidList.clear();
                } else {
                    Iterator<UUID> iterator = this.uuidList.iterator();
                    this.uuidList.removeIf(uui -> uui.equals(newUUID));
                }
                this.markDirty();
            }
        }
    }

    public List<BlockCoords> getCoords() {
        return this.coordList;
    }

    public List<UUID> getUUIDs() {
        return this.uuidList;
    }

    public boolean hasValidChannels() {
        return this.type == ChannelType.UNLIMITED || this.hasChannels();
    }

    public boolean hasChannels() {
        return this.uuidList.isEmpty() || this.coordList.isEmpty();
    }

    public boolean isEntityMonitored(UUID uuid) {
        if (this.type == ChannelType.UNLIMITED) {
            return this.coordList.isEmpty() && this.uuidList.isEmpty() || this.uuidList.contains(uuid);
        }
        return this.uuidList.contains(uuid);
    }

    public boolean isCoordsMonitored(BlockCoords coords) {
        if (this.type == ChannelType.UNLIMITED) {
            return this.coordList.isEmpty() && this.uuidList.isEmpty() || this.coordList.contains(coords);
        }
        return this.coordList.contains(coords);
    }

    public boolean isMonitored(NodeConnection connection) {
        if (connection instanceof BlockConnection) {
            return this.isCoordsMonitored(((BlockConnection)connection).coords);
        }
        if (connection instanceof EntityConnection) {
            return this.isEntityMonitored(((EntityConnection)connection).uuid);
        }
        return false;
    }

    public boolean add(BlockCoords coords) {
        if (!this.coordList.contains(coords)) {
            boolean add = this.coordList.add(coords);
            if (add) {
                this.markDirty();
            }
            return add;
        }
        return false;
    }

    public boolean addAll(Collection<? extends BlockCoords> coords) {
        boolean addAll = false;
        for (BlockCoords blockCoords : coords) {
            boolean add = this.add(blockCoords);
            if (!add) continue;
            addAll = true;
        }
        return addAll;
    }

    public boolean addUUID(UUID coords) {
        if (!this.uuidList.contains(coords)) {
            boolean add = this.uuidList.add(coords);
            if (add) {
                this.markDirty();
            }
            return add;
        }
        return false;
    }

    public boolean addAllUUID(Collection<? extends UUID> coords) {
        boolean addAll = false;
        for (UUID uUID : coords) {
            boolean add = this.addUUID(uUID);
            if (!add) continue;
            addAll = true;
        }
        return addAll;
    }

    public int hashCode() {
        return this.identity;
    }

    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)BlockCoords.writeBlockCoords((NBTTagCompound)new NBTTagCompound(), this.coordList, (String)this.getTagName()));
    }

    public void readFromBuf(ByteBuf buf) {
        this.coordList.clear();
        this.addAll(BlockCoords.readBlockCoords((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf), (String)this.getTagName()));
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt = BlockCoords.writeBlockCoords((NBTTagCompound)nbt, this.coordList, (String)this.getTagName());
        nbt = this.writeUUIDS(nbt);
        return nbt;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.coordList = BlockCoords.readBlockCoords((NBTTagCompound)nbt, (String)this.getTagName());
            this.uuidList = this.readUUIDS(nbt);
        }
    }

    public List<UUID> readUUIDS(NBTTagCompound nbt) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        NBTTagList list = nbt.func_150295_c("uuids", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound uuidTag = list.func_150305_b(i);
            uuids.add(uuidTag.func_186857_a("id"));
        }
        return uuids;
    }

    public NBTTagCompound writeUUIDS(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (UUID uuid : this.uuidList) {
            NBTTagCompound uuidTag = new NBTTagCompound();
            uuidTag.func_186854_a("id", uuid);
            list.func_74742_a((NBTBase)uuidTag);
        }
        nbt.func_74782_a("uuids", (NBTBase)list);
        return nbt;
    }

    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC});
    }

    public String getTagName() {
        return String.valueOf(this.tagID);
    }

    public ISyncableListener getListener() {
        return this.listener;
    }

    public void markDirty() {
        if (this.listener != null) {
            this.listener.markChanged((IDirtyPart)this);
        }
    }
}

