/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.channels;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.items.IItemHandler;
import sonar.core.handlers.inventories.handling.ItemTransferHelper;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.channels.NodeConnectionType;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredEntity;

public class EntityConnection
extends NodeConnection<MonitoredEntity> {
    public Entity entity;
    public UUID uuid;
    public String name;
    public int dim;

    public EntityConnection(INetworkTile source, Entity entity) {
        super(source);
        this.uuid = entity.getPersistentID();
        this.name = entity.func_70005_c_();
        this.dim = entity.field_71093_bK;
        this.entity = entity;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityConnection) {
            return ((EntityConnection)obj).uuid.equals(this.uuid);
        }
        return false;
    }

    @Override
    public MonitoredEntity getChannel() {
        return new MonitoredEntity(this);
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler() {
        if (this.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.entity;
            return ItemTransferHelper.getMainInventoryHandler((EntityPlayer)player);
        }
        return null;
    }

    @Override
    public NodeConnectionType getType() {
        return NodeConnectionType.ENTITY;
    }
}

