/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.channels;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.core.tiles.displays.info.types.general.InfoChangeableList;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;

public class PacketChannels
implements IMessage {
    public InfoChangeableList list;
    public NBTTagCompound listTag;
    public int registryID;

    public PacketChannels() {
    }

    public PacketChannels(int registryID, NBTTagCompound listTag) {
        this.listTag = listTag;
        this.registryID = registryID;
    }

    public void fromBytes(ByteBuf buf) {
        this.registryID = buf.readInt();
        this.listTag = ByteBufUtils.readTag((ByteBuf)buf);
        if (this.listTag != null) {
            this.list = (InfoChangeableList)InfoHelper.readMonitoredList(this.listTag, (AbstractChangeableList)ClientInfoHandler.instance().channelMap.getOrDefault(this.registryID, new InfoChangeableList()), NBTHelper.SyncType.DEFAULT_SYNC);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.registryID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.listTag);
    }

    public static class Handler
    implements IMessageHandler<PacketChannels, IMessage> {
        public IMessage onMessage(PacketChannels message, MessageContext ctx) {
            if (message.list != null) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> ClientInfoHandler.instance().channelMap.put(message.registryID, message.list));
            }
            return null;
        }
    }
}

