/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.data.api;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sonar.logistics.base.data.api.IData;
import sonar.logistics.base.data.api.IDataGenerator;
import sonar.logistics.base.data.api.IDataWatcher;
import sonar.logistics.base.data.sources.IDataSource;

public interface IDataHolder<T extends IData> {
    default public boolean isValid() {
        return true;
    }

    public List<IDataWatcher> getDataWatchers();

    default public void addWatcher(IDataWatcher watcher) {
        this.getDataWatchers().add(watcher);
    }

    default public void removeWatcher(IDataWatcher watcher) {
        this.getDataWatchers().remove(watcher);
    }

    default public void onWatchersChanged() {
    }

    default public void onDataChanged() {
        this.getDataWatchers().forEach(w -> w.onDataChanged(this));
    }

    default public void onHolderDestroyed() {
    }

    @Nullable
    public IDataGenerator<IDataSource, T, IDataHolder<T>> getGenerator();

    public boolean canUpdateData();

    @Nonnull
    public T getData();

    @Nonnull
    public IDataSource getSource();

    public void setData(T var1);

    public boolean hasWatchers();

    public void setWatchers(boolean var1);

    public void tick();

    public void setTick(int var1);
}

