/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.data.holders;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sonar.core.SonarCore;
import sonar.logistics.base.data.api.IData;
import sonar.logistics.base.data.api.IDataGenerator;
import sonar.logistics.base.data.api.IDataHolder;
import sonar.logistics.base.data.api.IDataWatcher;
import sonar.logistics.base.data.sources.IDataSource;

public class DataHolder<T extends IData, H extends IDataHolder<T>>
implements IDataHolder<T> {
    public final IDataGenerator<IDataSource, T, H> generator;
    public final List<IDataWatcher> dataWatchers;
    public final IDataSource source;
    public T data;
    public int ticks;
    public int tickRate;
    public boolean hasWatchers = false;

    public DataHolder(IDataGenerator<IDataSource, T, H> generator, IDataSource source, T freshData, int tickRate) {
        this.generator = generator;
        this.dataWatchers = new ArrayList<IDataWatcher>();
        this.source = source;
        this.data = freshData;
        this.tickRate = tickRate;
        this.ticks = SonarCore.randInt((int)0, (int)tickRate);
    }

    @Override
    public IDataGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public List<IDataWatcher> getDataWatchers() {
        return this.dataWatchers;
    }

    @Override
    public boolean canUpdateData() {
        return !this.dataWatchers.isEmpty() && this.ticks == this.tickRate;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    @Nonnull
    public IDataSource getSource() {
        return this.source;
    }

    @Override
    public void setData(T value) {
        this.data = value;
    }

    @Override
    public boolean hasWatchers() {
        return this.hasWatchers;
    }

    @Override
    public void setWatchers(boolean setWatchers) {
        this.hasWatchers = setWatchers;
    }

    @Override
    public void onWatchersChanged() {
        if (this.getDataWatchers().isEmpty()) {
            this.setWatchers(false);
            return;
        }
        for (IDataWatcher watcher : this.getDataWatchers()) {
            if (!watcher.isWatched()) continue;
            this.setWatchers(true);
            return;
        }
        this.setWatchers(false);
    }

    @Override
    public void tick() {
        if (!this.hasWatchers || !this.dataWatchers.isEmpty()) {
            return;
        }
        this.ticks = this.ticks >= this.tickRate ? 0 : ++this.ticks;
    }

    @Override
    public void setTick(int tick) {
        this.ticks = tick;
    }
}

