/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.GuiGridElement;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.IGridGui;
import sonar.core.client.gui.SelectionGrid;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.utils.IWorldPosition;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.base.gui.GuiLogistics;
import sonar.logistics.base.gui.PL2Colours;

public abstract class GuiSelectionGrid2<T extends IInfo>
extends GuiLogistics
implements IGridGui {
    public Map<SelectionGrid, SonarScroller> grids = new HashMap<SelectionGrid, SonarScroller>();
    private int defgridXStart = 13;
    private int defgridYStart = 32;
    private int defgridElementWidth = 18;
    private int defgridElementHeight = 18;
    private int defgridWidth = 12;
    private int defgridHeight = 7;

    public GuiSelectionGrid2(Container container, IWorldPosition entity) {
        super(container, entity);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 248;
        this.field_147000_g = 256;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.addGrids(this.grids);
    }

    public void addGrids(Map<SelectionGrid, SonarScroller> grids) {
        SonarScroller grid_scroller = new SonarScroller(this.field_147003_i + this.defgridXStart + this.defgridElementWidth * this.defgridWidth + 3, this.field_147009_r + this.defgridYStart - 1, this.defgridElementHeight * this.defgridHeight + 2, 10);
        SelectionGrid grid = new SelectionGrid((IGridGui)this, 0, this.defgridXStart, this.defgridYStart, this.defgridElementWidth, this.defgridElementHeight, this.defgridWidth, this.defgridHeight);
        grids.put(grid, grid_scroller);
    }

    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (button == 0 || button == 1) {
            this.grids.forEach((grid, scroll) -> grid.mouseClicked((GuiSonar)this, x, y, button));
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.renderStrings(x, y);
        this.grids.forEach((grid, scroll) -> {
            this.renderScroller((SonarScroller)scroll);
            grid.renderGrid((GuiSonar)this, x, y);
        });
    }

    public void startToolTipRender(int gridID, T selection, int x, int y) {
        GL11.glDisable((int)2929);
        GlStateManager.func_179140_f();
        this.renderElementToolTip(gridID, selection, x, y);
        GlStateManager.func_179145_e();
        GL11.glEnable((int)2929);
        RenderHelper.func_74520_c();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.grids.forEach((grid, scroll) -> scroll.handleMouse((GuiGridElement)grid));
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        this.grids.forEach((grid, scroll) -> {
            grid.setList((List)Lists.newArrayList(this.getGridList(grid.gridID)));
            scroll.drawScreen(x, y, grid.isScrollable());
        });
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        this.renderPlayerInventory(40, 173);
        this.grids.forEach((grid, scroll) -> {
            GuiSelectionGrid2.drawTransparentRect((int)(this.field_147003_i + grid.xPos - 1), (int)(this.field_147009_r + grid.yPos - 1), (int)(this.field_147003_i + grid.xPos + grid.eWidth * grid.gWidth - 1), (int)(this.field_147009_r + grid.yPos + grid.eHeight * grid.gHeight - 1), (int)PL2Colours.grey_base.getRGB());
            GuiSelectionGrid2.drawTransparentRect((int)(this.field_147003_i + grid.xPos), (int)(this.field_147009_r + grid.yPos), (int)(this.field_147003_i + grid.xPos + grid.eWidth * grid.gWidth - 2), (int)(this.field_147009_r + grid.yPos + grid.eHeight * grid.gHeight - 2), (int)PL2Colours.blue_overlay.getRGB());
        });
        GuiSelectionGrid2.drawTransparentRect((int)(this.field_147003_i + 12), (int)(this.field_147009_r + 170), (int)(this.field_147003_i + this.field_146999_f - 9), (int)(this.field_147009_r + 252), (int)PL2Colours.grey_base.getRGB());
        GuiSelectionGrid2.drawTransparentRect((int)(this.field_147003_i + 13), (int)(this.field_147009_r + 171), (int)(this.field_147003_i + this.field_146999_f - 10), (int)(this.field_147009_r + 251), (int)PL2Colours.blue_overlay.getRGB());
    }

    public abstract List<T> getGridList(int var1);

    public abstract void renderStrings(int var1, int var2);
}

