/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.guidance.errors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.asm.ASMInfoError;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.guidance.errors.ErrorTileUUID;
import sonar.logistics.base.guidance.errors.IInfoError;
import sonar.logistics.base.tiles.INetworkTile;

@ASMInfoError(id="disconnect", modid="practicallogistics2")
public class ErrorDisconnected
extends ErrorTileUUID {
    public boolean chunkUnload = false;

    public ErrorDisconnected() {
    }

    public ErrorDisconnected(InfoUUID uuid, INetworkTile tile) {
        super(uuid, tile);
    }

    public ErrorDisconnected(List<InfoUUID> uuids, INetworkTile tile) {
        super(uuids, tile);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.chunkUnload = nbt.func_74767_n("chunk");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74757_a("chunk", this.chunkUnload);
        return nbt;
    }

    @Override
    public List<String> getDisplayMessage() {
        ArrayList message = Lists.newArrayList();
        message.add(TextFormatting.BOLD + (this.chunkUnload ? "Connection Not Chunk Loaded" : "Connection Disconnected"));
        if (!this.displayStack.func_190926_b()) {
            message.add("NAME: " + this.displayStack.func_82833_r());
        }
        if (this.coords != null) {
            message.add("POS: " + this.coords.toString());
        }
        message.add("ID: " + this.identity);
        return message;
    }

    @Override
    public boolean canDisplayInfo(IInfo info) {
        return false;
    }

    @Override
    public boolean canCombine(IInfoError error) {
        return error instanceof ErrorDisconnected && ((ErrorDisconnected)error).identity == this.identity;
    }

    @Override
    public void addError(IInfoError error) {
        ErrorDisconnected dError = (ErrorDisconnected)error;
        ListHelper.addWithCheck((Collection)this.uuids, (Collection)dError.uuids);
        this.chunkUnload = dError.chunkUnload || this.chunkUnload;
    }

    @Override
    public void removeError(IInfoError error) {
        ErrorDisconnected dError = (ErrorDisconnected)error;
        dError.uuids.forEach(uuid -> this.uuids.remove(uuid));
        this.chunkUnload = dError.chunkUnload;
    }
}

