/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.listeners;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerList;
import sonar.core.listener.PlayerListener;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.core.tiles.displays.DisplayViewerHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;

public class PL2ListenerList
extends ListenableList<PlayerListener> {
    public ListenerList<DisplayGSI> displayListeners = new ListenerList(1);

    public PL2ListenerList(ISonarListenable<PlayerListener> listen, int maxTypes) {
        super(listen, maxTypes);
    }

    public List<PlayerListener> getAllListeners(ListenerType ... enums) {
        List listeners = super.getListeners((Enum[])enums);
        for (ListenerType type : enums) {
            if (type != ListenerType.OLD_DISPLAY_LISTENER) continue;
            List displays = this.displayListeners.getListeners(new int[]{0});
            List<EntityPlayerMP> players = DisplayViewerHandler.instance().getWatchingPlayers(displays);
            players.forEach(player -> {
                PlayerListener listener = new PlayerListener(player);
                if (!listeners.contains(listener)) {
                    listeners.add(listener);
                }
            });
        }
        return listeners;
    }

    public List<PlayerListener> getDisplayPlayerListeners() {
        ArrayList<PlayerListener> listeners = new ArrayList<PlayerListener>();
        List displays = this.displayListeners.getListeners(new int[]{0});
        List<EntityPlayerMP> players = DisplayViewerHandler.instance().getWatchingPlayers(displays);
        players.forEach(player -> {
            PlayerListener listener = new PlayerListener(player);
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        });
        return listeners;
    }

    public boolean hasListeners() {
        boolean hasListeners = super.hasListeners();
        if (!hasListeners) {
            List displays = this.displayListeners.getListeners(new int[]{0});
            for (DisplayGSI display : displays) {
                List<EntityPlayerMP> players = DisplayViewerHandler.instance().getWatchingPlayers(display);
                if (players.isEmpty()) continue;
                return true;
            }
        }
        return hasListeners;
    }

    public ListenerList<DisplayGSI> getDisplayListeners() {
        return this.displayListeners;
    }

    public void invalidateList() {
        super.invalidateList();
        this.displayListeners.invalidateList();
    }
}

