/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.utils.slots;

import mcmultipart.api.slot.EnumEdgeSlot;
import mcmultipart.api.slot.EnumSlotAccess;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public enum EnumDisplayFaceSlot implements IPartSlot
{
    DOWN_DISPLAY(EnumFacing.DOWN),
    UP_DISPLAY(EnumFacing.UP),
    NORTH_DISPLAY(EnumFacing.NORTH),
    SOUTH_DISPLAY(EnumFacing.SOUTH),
    WEST_DISPLAY(EnumFacing.WEST),
    EAST_DISPLAY(EnumFacing.EAST);

    public static final EnumDisplayFaceSlot[] VALUES;
    private final ResourceLocation name = new ResourceLocation("practicallogistics2", this.name().toLowerCase() + "display");
    private final EnumFacing facing;

    private EnumDisplayFaceSlot(EnumFacing facing) {
        this.facing = facing;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public EnumDisplayFaceSlot getOpposite() {
        return VALUES[this.ordinal() ^ 1];
    }

    public EnumSlotAccess getFaceAccess(EnumFacing face) {
        return face == this.getFacing() ? EnumSlotAccess.OVERRIDE : (face != this.getOpposite().getFacing() ? EnumSlotAccess.MERGE : EnumSlotAccess.NONE);
    }

    public int getFaceAccessPriority(EnumFacing face) {
        return face == this.getFacing() ? 301 : (face != this.getOpposite().getFacing() ? 251 : 0);
    }

    public EnumSlotAccess getEdgeAccess(EnumEdgeSlot edge, EnumFacing face) {
        return edge.getFace1() == face || edge.getFace2() == face ? EnumSlotAccess.OVERRIDE : EnumSlotAccess.NONE;
    }

    public int getEdgeAccessPriority(EnumEdgeSlot edge, EnumFacing face) {
        return 201;
    }

    public static EnumDisplayFaceSlot fromFace(EnumFacing face) {
        return VALUES[face.ordinal()];
    }

    static {
        VALUES = EnumDisplayFaceSlot.values();
    }
}

