/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.guide.pages.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3d;
import net.minecraft.util.math.BlockPos;
import sonar.core.client.gui.GuiBlockRenderer3D;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.core.tiles.displays.tiles.connected.TileLargeDisplayScreen;

public class Logistics3DRenderer
extends GuiBlockRenderer3D {
    Map<BlockPos, List<DisplayElementContainer>> containers = new HashMap<BlockPos, List<DisplayElementContainer>>();

    public Logistics3DRenderer(int cubeSize) {
        super(cubeSize);
    }

    public void addDisplayContainer(BlockPos pos, DisplayElementContainer container) {
        this.containers.putIfAbsent(pos, new ArrayList());
        this.containers.get(pos).add(container);
    }

    public void doSpecialRender(GuiBlockRenderer3D.GuiBlockRenderCache cache, Vector3d at) {
        if (cache.tile instanceof TileAbstractDisplay) {
            this.renderScreenAt(cache, at, cache.pos, 0.0f);
        } else {
            super.doSpecialRender(cache, at);
        }
    }

    public void renderScreenAt(GuiBlockRenderer3D.GuiBlockRenderCache cache, Vector3d at, BlockPos pos, float partialTicks) {
        TileAbstractDisplay part = (TileAbstractDisplay)cache.tile;
        if (part instanceof TileLargeDisplayScreen && !((Boolean)((TileLargeDisplayScreen)part).shouldRender.getObject()).booleanValue()) {
            return;
        }
        super.doSpecialRender(cache, at);
        List<DisplayElementContainer> toRender = this.containers.get(pos);
        if (toRender == null || !toRender.isEmpty()) {
            // empty if block
        }
    }
}

