/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.wirelessstoragereader;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.helpers.FontHelper;
import sonar.core.network.PacketFlexibleCloseGui;
import sonar.core.network.utils.ByteBufWritable;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.core.tiles.readers.IWirelessStorageReader;
import sonar.logistics.api.core.tiles.wireless.emitters.ClientWirelessEmitter;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.gui.GuiSelectionList;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.base.gui.overlays.OverlayBlockSelection;
import sonar.logistics.core.items.wirelessstoragereader.ContainerEmitterList;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.network.packets.PacketWirelessStorage;

public class GuiWirelessStorageEmitterList
extends GuiSelectionList<ClientWirelessEmitter> {
    public EntityPlayer player;
    public ItemStack reader;
    public int clickedIdentity = -1;

    public GuiWirelessStorageEmitterList(ItemStack reader, EntityPlayer player) {
        super(new ContainerEmitterList(player), null);
        this.reader = reader;
        this.field_146999_f = 248;
        this.player = player;
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)PL2Translate.WIRELESS_STORAGE_READER.t(), (int)this.field_146999_f, (int)6, (CustomColour)PL2Colours.white_text);
        FontHelper.textCentre((String)PL2Translate.DATA_RECEIVER_HELP.t(), (int)this.field_146999_f, (int)18, (CustomColour)PL2Colours.grey_text);
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, ClientWirelessEmitter info) {
        if (buttonID == 1) {
            OverlayBlockSelection.addPosition(info.coords.getCoords(), false);
        } else {
            final int identity = info.getIdentity();
            PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 1, new ByteBufWritable(false){

                public void writeToBuf(ByteBuf buf) {
                    buf.writeInt(identity);
                }
            }));
            this.clickedIdentity = identity;
        }
    }

    @Override
    public void setInfo() {
        this.infoList = Lists.newArrayList(ClientInfoHandler.instance().clientDataEmitters);
    }

    @Override
    public boolean isCategoryHeader(ClientWirelessEmitter info) {
        if (!OverlayBlockSelection.positions.isEmpty()) {
            return OverlayBlockSelection.isPositionRenderered(info.coords.getCoords());
        }
        return false;
    }

    @Override
    public boolean isSelectedInfo(ClientWirelessEmitter info) {
        ItemStack current;
        if (info.getIdentity() == this.clickedIdentity) {
            return true;
        }
        if (this.clickedIdentity == -1 && (current = this.player.func_184614_ca()).func_77942_o()) {
            int uuid = current.func_77978_p().func_74762_e("uuid");
            return uuid == info.getIdentity();
        }
        return false;
    }

    @Override
    public void renderInfo(ClientWirelessEmitter info, int yPos) {
        int colour = PL2Colours.white_text.getRGB();
        FontHelper.text((String)((String)info.name.getObject()), (int)InfoRenderHelper.left_offset, (int)yPos, (int)colour);
        FontHelper.text((String)info.coords.getCoords().toString(), (int)173, (int)yPos, (int)colour);
    }

    @Override
    public int getColour(int i, int type) {
        return PL2Colours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isPairedInfo(ClientWirelessEmitter info) {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if ((keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) && SonarCore.instance.guiHandler.lastScreen != null) {
            SonarCore.network.sendToServer((IMessage)new PacketFlexibleCloseGui(this.player.func_180425_c()));
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }
}

