/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.wirelessstoragereader;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.logistics.api.core.tiles.readers.IWirelessStorageReader;
import sonar.logistics.api.core.tiles.wireless.emitters.IDataEmitter;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.core.items.wirelessstoragereader.ContainerEmitterList;
import sonar.logistics.core.items.wirelessstoragereader.ContainerStorageViewer;
import sonar.logistics.core.items.wirelessstoragereader.GuiWirelessStorageEmitterList;
import sonar.logistics.core.items.wirelessstoragereader.GuiWirelessStorageReader;
import sonar.logistics.core.tiles.readers.items.handling.ItemHelper;
import sonar.logistics.core.tiles.wireless.handling.WirelessDataManager;

public class ItemWirelessStorageReader
extends SonarItem
implements IWirelessStorageReader,
IFlexibleGui<ItemStack> {
    public static final String EMITTER_UUID = "uuid";
    public static final String NETWORK_ID = "network_id";

    @Override
    public int getEmitterIdentity(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(EMITTER_UUID)) {
            return stack.func_77978_p().func_74762_e(EMITTER_UUID);
        }
        return -1;
    }

    public void setEmitterIdentity(int identity, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a(EMITTER_UUID, identity);
        stack.func_77982_d(nbt);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !stack.func_190926_b()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            Integer identity = this.getEmitterIdentity(stack);
            IDataEmitter emitter = (IDataEmitter)WirelessDataManager.instance().getEmitter(identity);
            if (emitter != null && !player.func_70093_af()) {
                if (!emitter.getCoords().isChunkLoaded(world)) {
                    FontHelper.sendMessage((String)"The Emitter isn't chunk loaded", (World)world, (EntityPlayer)player);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74757_a(FlexibleGuiHandler.ITEM, true);
                tag.func_74768_a(EMITTER_UUID, emitter.getIdentity());
                tag.func_74768_a(NETWORK_ID, emitter.getNetworkID());
                SonarCore.instance.guiHandler.openGui(false, player, world, player.func_180425_c(), 0, tag);
            } else {
                SonarCore.instance.guiHandler.openBasicItemStack(false, stack, player, world, player.func_180425_c(), 1);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onGuiOpened(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                IDataEmitter emitter = (IDataEmitter)WirelessDataManager.instance().getEmitter(this.getEmitterIdentity(obj));
                if (emitter == null) break;
                emitter.sendRapidUpdate(player);
                emitter.getListenerList().addListener(player, new Enum[]{ListenerType.OLD_GUI_LISTENER});
                break;
            }
            case 1: {
                WirelessDataManager.instance().addViewer(player);
            }
        }
    }

    public Object getServerElement(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerStorageViewer(tag.func_74762_e(EMITTER_UUID), player);
            }
            case 1: {
                return new ContainerEmitterList(player);
            }
        }
        return null;
    }

    public Object getClientElement(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiWirelessStorageReader(obj, tag.func_74762_e(EMITTER_UUID), tag.func_74762_e(NETWORK_ID), player);
            }
            case 1: {
                return new GuiWirelessStorageEmitterList(obj, player);
            }
        }
        return null;
    }

    @Override
    public void readPacket(ItemStack stack, EntityPlayer player, ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                ItemStack selected = null;
                if (buf.readBoolean()) {
                    selected = ByteBufUtils.readItemStack((ByteBuf)buf);
                }
                IDataEmitter emitter = (IDataEmitter)WirelessDataManager.instance().getEmitter(this.getEmitterIdentity(stack));
                ItemHelper.onNetworkItemInteraction(emitter, emitter.getNetwork(), emitter.getServerItems(), player, selected, buf.readInt());
                break;
            }
            case 1: {
                int entityUUID = buf.readInt();
                this.setEmitterIdentity(entityUUID, stack);
                player.func_184611_a(EnumHand.MAIN_HAND, stack);
            }
        }
    }

    @Override
    public void writePacket(ItemStack stack, EntityPlayer player, ByteBuf buf, int id) {
        switch (id) {
            default: 
        }
    }
}

