/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.data.handling;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FunctionHelper;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.ICable;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetworkHandler;

public abstract class AbstractConnectionHandler<T extends ICable> {
    protected Map<Integer, List<T>> connections = new ConcurrentHashMap<Integer, List<T>>();
    private LogisticsNetworkHandler NetworkManager;

    public void removeAll() {
        this.connections.clear();
        this.NetworkManager = null;
    }

    public LogisticsNetworkHandler NetworkManager() {
        if (this.NetworkManager == null) {
            this.NetworkManager = PL2.proxy.networkManager;
        }
        return this.NetworkManager;
    }

    public int getNextAvailableID() {
        for (int i = 0; i < this.connections.size(); ++i) {
            if (this.connections.get(i) != null && !this.connections.get(i).isEmpty() && this.connections.get(i).size() != 0) continue;
            return i;
        }
        return this.connections.size();
    }

    /*
     * WARNING - void declaration
     */
    public List<T> getConnections(int registryID) {
        void var2_2;
        List<T> coords;
        return registryID == -1 || (coords = this.connections.get(registryID)) == null ? new ArrayList() : var2_2;
    }

    public void addConnections(int registryID, List<T> connections) {
        connections.forEach(connection -> this.addConnection(registryID, connection, false));
    }

    public int addConnection(T cable) {
        ArrayList<Pair<EnumCableConnectionType, Integer>> connections = new ArrayList<Pair<EnumCableConnectionType, Integer>>();
        int cableID = cable.getRegistryID();
        int lastSize = -1;
        BlockCoords coords = cable.getCoords();
        World world = cable.getActualWorld();
        BlockPos pos = coords.getBlockPos();
        for (EnumFacing dir : EnumFacing.values()) {
            if (!cable.canConnect(cable.getRegistryID(), cable.getConnectableType(), dir, false).canConnect()) continue;
            Pair<EnumCableConnectionType, Integer> connection = this.getConnectionType(cable, world, pos, dir, cable.getConnectableType());
            if (connection.a == EnumCableConnectionType.NONE || (Integer)connection.b == -1) continue;
            List<T> cables = this.getConnections((Integer)connection.b);
            if (cables.size() > lastSize) {
                cableID = (Integer)connection.b;
                lastSize = cables.size();
            }
            connections.add(connection);
        }
        cableID = cableID == -1 ? this.getNextAvailableID() : cableID;
        this.addConnection(cableID, cable, true);
        for (Pair pair : connections) {
            if ((Integer)pair.b == cableID) continue;
            this.connectNetworks(cableID, (Integer)pair.b);
        }
        return cableID;
    }

    public void addConnection(int registryID, T connection, boolean refreshCache) {
        List<T> network;
        if (registryID != -1 && connection != null && !(network = this.connections.computeIfAbsent(registryID, FunctionHelper.ARRAY)).contains(connection)) {
            connection.setRegistryID(registryID);
            network.add(connection);
            if (refreshCache) {
                this.onConnectionAdded(registryID, connection);
            }
        }
    }

    public void removeConnection(T connection) {
        int registryID = connection.getRegistryID();
        if (registryID != -1 && connection.getCoords() != null) {
            ArrayList allConnections = this.connections.get(registryID);
            if (allConnections == null) {
                return;
            }
            allConnections.remove(connection);
            this.onConnectionRemoved(registryID, connection);
            connection.setRegistryID(-1);
            allConnections = Lists.newArrayList(allConnections);
            this.connections.get(registryID).clear();
            this.connections.remove(registryID);
            if (!allConnections.isEmpty()) {
                ArrayList<Integer> newNetworks = new ArrayList<Integer>();
                allConnections.forEach(oldCable -> oldCable.setRegistryID(-1));
                if (!allConnections.isEmpty()) {
                    ICable cable = (ICable)allConnections.remove(0);
                    cable.setRegistryID(registryID);
                    this.addConnectionToNetwork(cable);
                }
                allConnections.forEach(oldCable -> {
                    this.addConnectionToNetwork(oldCable);
                    newNetworks.add(oldCable.getRegistryID());
                });
                this.onNetworksDisconnected(newNetworks);
            }
        }
    }

    public void refreshConnections(T cable) {
        BlockCoords coords = cable.getCoords();
        for (EnumFacing dir : EnumFacing.values()) {
            Pair<EnumCableConnectionType, Integer> connection = this.getConnectionType(cable, cable.getActualWorld(), coords.getBlockPos(), dir, cable.getConnectableType());
            boolean canConnect = cable.canConnect(cable.getRegistryID(), cable.getConnectableType(), dir, false).canConnect();
            if (!canConnect && ((EnumCableConnectionType)((Object)connection.a)).canConnect(cable.getConnectableType())) {
                this.removeConnectionFromNetwork(cable);
                this.addConnectionToNetwork(cable);
                continue;
            }
            if (!canConnect || !((EnumCableConnectionType)((Object)connection.a)).canConnect(cable.getConnectableType()) || ((Integer)connection.b).intValue() == cable.getRegistryID()) continue;
            this.connectNetworks(cable.getRegistryID(), (Integer)connection.b);
        }
    }

    public abstract Pair<EnumCableConnectionType, Integer> getConnectionType(T var1, World var2, BlockPos var3, EnumFacing var4, EnumCableConnectionType var5);

    public void connectNetworks(int newID, int secondaryID) {
        List<ICable> oldConnections = this.connections.get(secondaryID);
        if (oldConnections == null) {
            return;
        }
        oldConnections.forEach(removed -> this.onConnectionRemoved(secondaryID, removed));
        this.addConnections(newID, oldConnections);
        oldConnections.clear();
        this.connections.remove(secondaryID);
        this.onNetworksConnected(newID, secondaryID);
    }

    public abstract void onNetworksDisconnected(List<Integer> var1);

    public abstract void onNetworksConnected(int var1, int var2);

    public abstract void onConnectionAdded(int var1, T var2);

    public abstract void onConnectionRemoved(int var1, T var2);

    public abstract void addConnectionToNetwork(T var1);

    public abstract void removeConnectionFromNetwork(T var1);
}

