/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.data.handling;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.utils.Pair;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.connections.ICable;
import sonar.logistics.api.core.tiles.connections.ICableConnectable;
import sonar.logistics.api.core.tiles.connections.data.IDataCable;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.api.core.tiles.displays.tiles.ILargeDisplay;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.base.utils.slots.EnumDisplayFaceSlot;
import sonar.logistics.core.tiles.connections.data.tiles.TileDataCable;

public class CableConnectionHelper {
    public static ICableConnectable getNetworkTile(ICable source, TileEntity tile, EnumFacing dir, boolean internal, boolean cableOnly) {
        IMultipartContainer container = null;
        if (!(tile instanceof IMultipartContainer)) {
            Optional cont = MultipartHelper.getContainer((IBlockAccess)tile.func_145831_w(), (BlockPos)tile.func_174877_v());
            container = cont.orElse(null);
        } else {
            container = (IMultipartContainer)tile;
        }
        if (container != null) {
            Optional cable;
            if (!cableOnly) {
                EnumFacing displaySlot;
                Optional display;
                Optional part = container.getPartTile((IPartSlot)EnumFaceSlot.fromFace((EnumFacing)dir));
                if (part.isPresent() && part.get() instanceof ICableConnectable) {
                    return (ICableConnectable)part.get();
                }
                if ((!internal || !(source instanceof ILargeDisplay)) && (display = container.getPartTile((IPartSlot)EnumDisplayFaceSlot.fromFace(displaySlot = source instanceof ILargeDisplay ? ((ILargeDisplay)source).getCableFace() : dir))).isPresent() && display.get() instanceof ICableConnectable) {
                    return (ICableConnectable)display.get();
                }
            }
            if (!internal && (cable = container.getPartTile((IPartSlot)EnumCenterSlot.CENTER)).isPresent() && cable.get() instanceof ICableConnectable) {
                return (ICableConnectable)cable.get();
            }
        } else if (!internal && tile instanceof ICableConnectable) {
            return (ICableConnectable)tile;
        }
        return null;
    }

    public static ICableConnectable getConnection(ICable cable, EnumFacing dir, EnumCableConnection type, boolean isInternal, boolean cableOnly) {
        EnumFacing actualDir;
        ICableConnectable connection;
        World world;
        TileEntity tile;
        if (type.matches(cable.canConnect(cable.getRegistryID(), cable.getConnectableType(), dir, isInternal)) && (tile = (world = cable.getActualWorld()).func_175625_s(isInternal ? cable.getCoords().getBlockPos() : cable.getCoords().getBlockPos().func_177972_a(dir))) != null && (connection = CableConnectionHelper.getNetworkTile(cable, tile, actualDir = isInternal ? dir : dir.func_176734_d(), isInternal, cableOnly)) != null && type.matches(connection.canConnect(cable.getRegistryID(), cable.getConnectableType(), actualDir, isInternal))) {
            return connection;
        }
        return null;
    }

    @Nullable
    public static ICableConnectable getConnection(ICable cable, EnumFacing dir, EnumCableConnection type, boolean cableOnly) {
        ICableConnectable internal = CableConnectionHelper.getConnection(cable, dir, type, true, cableOnly);
        return internal != null ? internal : CableConnectionHelper.getConnection(cable, dir, type, false, cableOnly);
    }

    public static EnumCableRenderSize getConnectionRenderType(ICable cable, EnumFacing dir) {
        ICableConnectable connection = CableConnectionHelper.getConnection(cable, dir, EnumCableConnection.VISUAL, false);
        return connection == null ? EnumCableRenderSize.NONE : connection.getCableRenderSize(dir);
    }

    public static EnumCableConnectionType getConnectableType(ICable cable, EnumFacing dir) {
        ICableConnectable connection = CableConnectionHelper.getConnection(cable, dir, EnumCableConnection.NETWORK, false);
        return CableConnectionHelper.getConnectableType(connection);
    }

    public static EnumCableConnectionType getConnectableType(ICableConnectable connection) {
        return connection == null ? EnumCableConnectionType.NONE : (connection instanceof ICable ? ((ICable)connection).getConnectableType() : EnumCableConnectionType.TILE);
    }

    public static IDisplay getDisplay(World world, BlockPos pos, EnumDisplayFaceSlot slot) {
        IDisplay display = null;
        Optional multipartTile = MultipartHelper.getPartTile((IBlockAccess)world, (BlockPos)pos, (IPartSlot)slot);
        if (multipartTile.isPresent() && multipartTile.get() instanceof IDisplay) {
            display = (IDisplay)multipartTile.get();
        }
        return display;
    }

    public static Pair<EnumCableConnectionType, Integer> getCableConnection(ICable source, World world, BlockPos pos, EnumFacing dir, EnumCableConnectionType cableType) {
        EnumCableConnectionType type;
        ICableConnectable external = CableConnectionHelper.getConnection(source, dir, EnumCableConnection.NETWORK, false, true);
        return new Pair((Object)type, (Object)((type = CableConnectionHelper.getConnectableType(external)) == cableType ? ((ICable)external).getRegistryID() : -1));
    }

    public static TileDataCable getCable(IBlockAccess world, BlockPos pos) {
        IBlockAccess actualWorld = SonarMultipartHelper.unwrapBlockAccess((IBlockAccess)world);
        TileEntity tile = actualWorld.func_175625_s(pos);
        if (tile != null) {
            if (tile instanceof TileDataCable) {
                return (TileDataCable)tile;
            }
            Optional cable = MultipartHelper.getPartTile((IBlockAccess)actualWorld, (BlockPos)pos, (IPartSlot)EnumCenterSlot.CENTER);
            if (cable.isPresent() && cable.get() instanceof TileDataCable) {
                return (TileDataCable)cable.get();
            }
        }
        return null;
    }

    public static List<IInfoProvider> getLocalMonitors(IDataCable cable) {
        ArrayList<IInfoProvider> logicTiles = new ArrayList<IInfoProvider>();
        for (EnumFacing face : EnumFacing.values()) {
            ICableConnectable connect = CableConnectionHelper.getConnection(cable, face, EnumCableConnection.VISUAL, false, false);
            if (!(connect instanceof IInfoProvider)) continue;
            logicTiles.add((IInfoProvider)connect);
        }
        return logicTiles;
    }

    public static List<INetworkTile> getConnectedTiles(IDataCable cable) {
        return CableConnectionHelper.getConnectedTiles(cable, INetworkTile.class);
    }

    public static <T> List<T> getConnectedTiles(IDataCable cable, Class<T> type) {
        return CableConnectionHelper.getConnectedTiles(cable, type::isInstance);
    }

    public static <T> List<T> getConnectedTiles(IDataCable cable, Predicate validate) {
        ArrayList<ICableConnectable> logicTiles = new ArrayList<ICableConnectable>();
        for (EnumFacing face : EnumFacing.values()) {
            ICableConnectable connection = CableConnectionHelper.getConnection(cable, face, EnumCableConnection.NETWORK, false);
            if (connection == null || connection instanceof IDataCable || !validate.test(connection)) continue;
            logicTiles.add(connection);
        }
        return logicTiles;
    }

    public static boolean canDisplayConnectToItemNetwork(InfoUUID uuid, IDisplay display, int networkID) {
        return false;
    }
}

