/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.data.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.tileentity.TileEntity;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.utils.CacheType;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetworkHandler;

public class NetworkHelper {
    public static boolean forEachTileEntity(ILogisticsNetwork network, CacheType type, Predicate<NodeConnection> canUse, BiPredicate<BlockConnection, TileEntity> canContinue) {
        List<NodeConnection> connections = network.getConnections(type);
        for (NodeConnection entry : connections) {
            boolean bool;
            if (!canUse.test(entry) || !(entry instanceof BlockConnection)) continue;
            BlockConnection connection = (BlockConnection)entry;
            TileEntity tile = connection.coords.getTileEntity();
            if (tile == null || (bool = canContinue.test(connection, tile))) continue;
            return false;
        }
        return true;
    }

    public static List<ILogisticsNetwork> getAllNetworks(ILogisticsNetwork network, int networkType) {
        ArrayList<ILogisticsNetwork> networks = new ArrayList<ILogisticsNetwork>();
        NetworkHelper.addSubNetworks(networks, network, networkType);
        return networks;
    }

    public static void addSubNetworks(List<ILogisticsNetwork> building, ILogisticsNetwork network, int networkType) {
        building.add(network);
        List subNetworks = network.getListenerList().getListeners(new int[]{networkType});
        for (ILogisticsNetwork sub : subNetworks) {
            if (!sub.isValid() || building.contains(sub)) continue;
            NetworkHelper.addSubNetworks(building, sub, networkType);
        }
    }

    public static ILogisticsNetwork getNetwork(int networkID) {
        return LogisticsNetworkHandler.instance().getNetwork(networkID);
    }
}

