/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.elements;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.NetworkListElement;
import sonar.logistics.core.tiles.displays.info.types.LogicInfoList;
import sonar.logistics.core.tiles.displays.info.types.energy.MonitoredEnergyStack;

public class NetworkEnergyListElement
extends NetworkListElement<MonitoredEnergyStack> {
    public static final String REGISTRY_NAME = "n_energy_l";

    public NetworkEnergyListElement() {
    }

    public NetworkEnergyListElement(InfoUUID uuid) {
        super(uuid);
    }

    @Override
    public double getRenderHeight() {
        return Math.min(Math.min(this.element_size, this.getActualScaling()[1]), this.getActualScaling()[0] / 8.0);
    }

    @Override
    public void renderGridElement(MonitoredEnergyStack stack, int index) {
        GlStateManager.func_179145_e();
        double actualHeight = this.height * this.grid_fill_percentage;
        double scaling = this.height / 16.0 * this.grid_fill_percentage;
        double offset = Math.min(0.02, actualHeight / 10.0);
        double barScale = this.getActualScaling()[0] - 16.0 * scaling - offset;
        double barWidth = (double)stack.getEnergyStack().stored * barScale / (double)stack.getEnergyStack().capacity;
        double left = 16.0 * scaling + offset;
        double top = actualHeight / 2.0 + offset;
        double right = 16.0 * scaling + barWidth;
        double bottom = actualHeight - offset;
        DisplayElementHelper.drawRect(left, top, right, bottom, FontHelper.getIntFromColor((int)80, (int)180, (int)80));
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.001);
        DisplayElementHelper.drawRect(left - offset, top - offset, left - offset + barScale + offset, bottom + offset, FontHelper.getIntFromColor((int)20, (int)60, (int)20));
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.001);
        GlStateManager.func_179139_a((double)scaling, (double)scaling, (double)0.001);
        GlStateManager.func_179109_b((float)16.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179140_f();
        String string = stack.getMonitoredCoords().getClientIdentifier() + " - " + stack.getMonitoredCoords().getCoords().toString();
        string = FontHelper.trimToWidthWithParentheses((String)string, (String)"...", (int)((int)Math.floor(barScale / scaling)), (double)0.5);
        int finalWidth = (int)Math.floor(barScale / scaling) * 2;
        FontHelper.textCentre((String)string, (int)finalWidth, (int)4, (int)this.text_colour);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.05);
        FontHelper.textCentre((String)(stack.getClientIdentifier() + " - " + stack.getClientObject()), (int)finalWidth, (int)20, (int)this.text_colour);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.05);
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
        GlStateManager.func_179109_b((float)-16.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179140_f();
        RenderHelper.renderItemIntoGUI((ItemStack)stack.getDropStack().getItemStack(), (int)0, (int)0);
        GlStateManager.func_179145_e();
        GlStateManager.func_179141_d();
    }

    @Override
    public void onGridElementClicked(DisplayScreenClick click, LogicInfoList list, MonitoredEnergyStack stack) {
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

