/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.elements;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.core.tiles.displays.info.elements.AbstractInfoElement;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.ElementFillType;
import sonar.logistics.core.tiles.displays.info.elements.base.IClickableElement;
import sonar.logistics.core.tiles.displays.info.elements.base.ILookableElement;
import sonar.logistics.core.tiles.displays.info.types.LogicInfoList;

public abstract class NetworkGridElement<L>
extends AbstractInfoElement<LogicInfoList>
implements IClickableElement,
ILookableElement {
    public int pageCount = 0;
    public int xSlots;
    public int ySlots;
    public int perPage = 0;
    public List<L> cachedList = null;
    public double element_size = 0.4375;
    public int text_colour = 0xFFFFFF;
    public double grid_fill_percentage = 0.75;
    public double width;
    public double height;
    public double X_SPACING;
    public double Y_SPACING;
    public double centreX;
    public double centreY;
    public int start;
    public int stop;

    public NetworkGridElement() {
    }

    public NetworkGridElement(InfoUUID uuid) {
        super(uuid);
    }

    public abstract double getRenderWidth();

    public abstract double getRenderHeight();

    public abstract void renderGridElement(L var1, int var2);

    public abstract void onGridElementClicked(DisplayScreenClick var1, LogicInfoList var2, @Nullable L var3);

    @Override
    public void render(LogicInfoList list) {
        int totalPages;
        boolean needsPages;
        this.info = this.getGSI().getCachedInfo(this.uuid);
        this.cachedList = this.getCachedList(list, this.uuid);
        if (this.cachedList.isEmpty()) {
            InfoRenderHelper.renderCenteredStringsWithAdaptiveScaling(this.getActualScaling()[0], this.getActualScaling()[1], this.getActualScaling()[2], 0, 0.5, -1, Lists.newArrayList((Object[])new String[]{"EMPTY LIST"}));
            return;
        }
        this.width = this.getRenderWidth();
        this.height = this.getRenderHeight();
        this.centreX = this.width / 2.0 - this.width * this.grid_fill_percentage / 2.0;
        this.centreY = this.height / 2.0 - this.height * this.grid_fill_percentage / 2.0;
        this.xSlots = (int)Math.floor(this.getActualScaling()[0] / this.width);
        this.ySlots = (int)Math.floor(this.getActualScaling()[1] / this.height);
        this.X_SPACING = (this.getActualScaling()[0] - (double)this.xSlots * this.width) / (double)this.xSlots;
        this.Y_SPACING = (this.getActualScaling()[1] - (double)this.ySlots * this.height) / (double)this.ySlots;
        this.perPage = this.xSlots * this.ySlots;
        boolean bl = needsPages = this.perPage < this.cachedList.size();
        if (needsPages && this.perPage != 0) {
            double adjusted_height = this.getActualScaling()[1] - this.getActualScaling()[1] / 8.0;
            this.ySlots = (int)Math.floor(adjusted_height / this.height);
            this.Y_SPACING = (adjusted_height - (double)this.ySlots * this.height) / (double)this.ySlots;
        }
        this.perPage = this.xSlots * this.ySlots;
        if (this.perPage == 0) {
            InfoRenderHelper.renderCenteredStringsWithAdaptiveScaling(this.getActualScaling()[0], this.getActualScaling()[1], this.getActualScaling()[2], 0, 0.5, -1, Lists.newArrayList((Object[])new String[]{"ADJUST SCALING"}));
        }
        if (this.pageCount >= (totalPages = (int)Math.ceil((double)this.cachedList.size() / (double)this.perPage))) {
            this.pageCount = totalPages - 1;
        }
        this.start = Math.max(this.perPage * this.pageCount, 0);
        this.stop = Math.max(Math.min(this.perPage + this.perPage * this.pageCount, this.cachedList.size()), 0);
        this.preListRender();
        for (int i = this.start; i < this.stop; ++i) {
            GlStateManager.func_179094_E();
            int index = i - this.start;
            int xLevel = (int)((double)index - Math.floor(index / this.xSlots) * (double)this.xSlots);
            int yLevel = (int)Math.floor(index / this.xSlots);
            GlStateManager.func_179137_b((double)((double)xLevel * this.width + this.centreX + this.X_SPACING * ((double)xLevel + 0.5)), (double)((double)yLevel * this.height + this.centreY + this.Y_SPACING * ((double)yLevel + 0.5)), (double)0.005);
            this.renderGridElement(this.cachedList.get(i), index);
            GlStateManager.func_179121_F();
        }
        this.postListRender();
        if (needsPages && this.perPage != 0) {
            DisplayElementHelper.renderPageButons(this.getActualScaling(), this.pageCount + 1, totalPages);
        }
    }

    public void preListRender() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179140_f();
    }

    public void postListRender() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179101_C();
        RenderHelper.textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179121_F();
    }

    public List<L> getCachedList(LogicInfoList info, InfoUUID id) {
        AbstractChangeableList list;
        if (this.cachedList == null || info.listChanged) {
            info.listChanged = false;
            list = PL2.proxy.getInfoManager(true).getChangeableListMap().get(id);
            List<Object> list2 = this.cachedList = list != null ? (ArrayList)list.createSaveableList(info.listSorter) : new ArrayList();
            if (this.cachedList.size() < this.perPage * this.pageCount - 1) {
                this.pageCount = 0;
            }
        }
        this.cachedList = (list = PL2.proxy.getInfoManager(true).getChangeableListMap().get(id)) != null ? (ArrayList)list.createSaveableList(info.listSorter) : new ArrayList();
        return this.cachedList;
    }

    @Override
    public boolean isType(IInfo info) {
        return info instanceof LogicInfoList;
    }

    @Override
    public ElementFillType getFillType() {
        return ElementFillType.FILL_CONTAINER;
    }

    @Override
    public int onGSIClicked(DisplayScreenClick click, EntityPlayer player, double subClickX, double subClickY) {
        boolean needsPages;
        DisplayScreenClick subClick = new DisplayScreenClick().setClickPosition(new double[]{click.clickX - 0.5, click.clickY});
        subClick.identity = click.identity;
        subClick.doubleClick = click.doubleClick;
        subClick.gsi = click.gsi;
        subClick.type = click.type;
        subClick.intersect = click.intersect;
        if (this.cachedList == null || this.cachedList.isEmpty()) {
            if (this.info instanceof LogicInfoList) {
                this.onGridElementClicked(subClick, (LogicInfoList)this.info, null);
            }
            return -1;
        }
        int xSlot = 0;
        int ySlot = 0;
        for (int x = 0; x < this.xSlots; ++x) {
            double xStart = (double)x * this.width + this.centreX + this.X_SPACING * ((double)x + 0.5);
            double xStop = xStart + this.width;
            if (!(subClickX >= xStart) || !(subClickX < xStop)) continue;
            xSlot = x;
            break;
        }
        for (int y = 0; y < this.ySlots; ++y) {
            double yStart = (double)y * this.height + this.centreY + this.Y_SPACING * ((double)y + 0.5);
            double yStop = yStart + this.height;
            if (!(subClickY >= yStart) || !(subClickY < yStop)) continue;
            ySlot = y;
            break;
        }
        int slot = ySlot * this.xSlots + xSlot + this.start;
        if (this.info instanceof LogicInfoList) {
            LogicInfoList list = (LogicInfoList)this.info;
            L stack = slot < this.cachedList.size() ? (L)this.cachedList.get(slot) : null;
            this.onGridElementClicked(subClick, list, stack);
        }
        boolean bl = needsPages = this.perPage < this.cachedList.size();
        if (needsPages) {
            int totalPages = (int)Math.ceil((double)this.cachedList.size() / (double)this.perPage);
            this.pageCount = DisplayElementHelper.doPageClick(subClickX, subClickY, this.getActualScaling(), this.pageCount, totalPages);
        }
        return -1;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.element_size = nbt.func_74769_h("sizing");
        this.text_colour = nbt.func_74762_e("colour");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74780_a("sizing", this.element_size);
        nbt.func_74768_a("colour", this.text_colour);
        return nbt;
    }
}

