/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.elements;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.handlers.inventories.containers.ContainerMultipartSync;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.requests.info.GuiInfoSource;
import sonar.logistics.base.requests.info.IInfoRequirement;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.gui.GuiUnconfiguredInfoElement;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIElementPacketHelper;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.core.tiles.displays.info.elements.AbstractDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.ElementFillType;
import sonar.logistics.core.tiles.displays.info.elements.base.HeightAlignment;
import sonar.logistics.core.tiles.displays.info.elements.base.IClickableElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IInfoReferenceElement;
import sonar.logistics.core.tiles.displays.info.elements.base.ILookableElement;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

@ASMDisplayElement(id="u_info", modid="practicallogistics2")
public class UnconfiguredInfoElement
extends AbstractDisplayElement
implements ILookableElement,
IClickableElement,
IInfoReferenceElement,
IInfoRequirement,
IFlexibleGui {
    public List<IDisplayElement> elements;
    public InfoUUID uuid;
    public static final String REGISTRY_NAME = "u_info";

    public UnconfiguredInfoElement() {
        this.width_align = WidthAlignment.LEFT;
        this.height_align = HeightAlignment.TOP;
    }

    public UnconfiguredInfoElement(InfoUUID uuid) {
        this.uuid = uuid;
        this.width_align = WidthAlignment.LEFT;
        this.height_align = HeightAlignment.TOP;
    }

    @Override
    public void updateRender() {
        if (this.elements == null) {
            this.updateInfoElements();
        }
        this.elements.forEach(IDisplayElement::updateRender);
    }

    @Override
    public void render() {
        if (this.getInfoElements().isEmpty()) {
            InfoRenderHelper.renderCenteredStringsWithAdaptiveScaling(this.getActualScaling()[0], this.getActualScaling()[1], this.getActualScaling()[2], 0, 0.5, -1, Lists.newArrayList((Object[])new String[]{"NO DATA"}));
        } else {
            for (IDisplayElement e : this.getInfoElements()) {
                GlStateManager.func_179094_E();
                DisplayElementHelper.align(this.getHolder().getAlignmentTranslation(e));
                double scale = e.getActualScaling()[2];
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                e.render();
                GlStateManager.func_179121_F();
            }
        }
    }

    @Override
    public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        if (this.getInfoElements().isEmpty()) {
            return IGuiOrigin.withOrigin((IGuiOrigin)new GuiInfoSource(this, this.getGSI(), (Container)new ContainerMultipartSync((TileSonarMultipart)obj)), (Object)origin);
        }
        return new GuiUnconfiguredInfoElement(obj, this, origin);
    }

    @Override
    public void onElementChanged() {
        super.onElementChanged();
        this.elements = null;
    }

    @Override
    public void onInfoReferenceChanged(InfoUUID uuid, IInfo info) {
        if (this.uuid.equals(uuid)) {
            this.updateInfoElements();
            this.getInfoElements().stream().filter(e -> e instanceof IInfoReferenceElement).forEach(e -> ((IInfoReferenceElement)e).onInfoReferenceChanged(this.uuid, info));
        }
    }

    public void updateInfoElements() {
        IInfo info = this.getGSI().getCachedInfo(this.uuid);
        if (info == null) {
            this.elements = new ArrayList<IDisplayElement>();
            return;
        }
        ArrayList<IDisplayElement> nElements = new ArrayList<IDisplayElement>();
        info.createDefaultElements(nElements, this.getHolder(), this.uuid);
        nElements.forEach(e -> e.setHolder(this.getHolder()));
        this.elements = nElements;
    }

    public List<IDisplayElement> getInfoElements() {
        if (this.elements == null) {
            this.updateInfoElements();
        }
        return this.elements;
    }

    @Override
    public double[] getMaxScaling() {
        return new double[]{this.getHolder().getContainer().getContainerMaxScaling()[0], this.getHolder().getContainer().getContainerMaxScaling()[1], 1.0};
    }

    @Override
    public double[] getActualScaling() {
        return this.getMaxScaling();
    }

    @Override
    public List<InfoUUID> getInfoReferences() {
        return Lists.newArrayList((Object[])new InfoUUID[]{this.uuid});
    }

    @Override
    public String getRepresentiveString() {
        return "Unconfigured: " + this.uuid.toString();
    }

    @Override
    public ElementFillType getFillType() {
        return ElementFillType.FILL_CONTAINER;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.uuid = new InfoUUID();
        this.uuid.readData(nbt, type);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        this.uuid.writeData(nbt, type);
        return nbt;
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }

    @Override
    public int onGSIClicked(DisplayScreenClick click, EntityPlayer player, double subClickX, double subClickY) {
        if (this.getInfoElements().isEmpty()) {
            return -2;
        }
        for (IDisplayElement e : this.elements) {
            double subSubClickY;
            double[] align;
            double subSubClickX;
            int gui;
            if (!(e instanceof IClickableElement) || (gui = ((IClickableElement)e).onGSIClicked(click, player, subSubClickX = subClickX - (align = this.getHolder().getAlignmentTranslation(e))[0], subSubClickY = subClickY - align[1])) == -1) continue;
            return gui;
        }
        return -1;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        if (this.elements != null) {
            for (IDisplayElement e : this.elements) {
                Object element;
                if (!(e instanceof IFlexibleGui) || (element = ((IFlexibleGui)e).getServerElement(obj, id, world, player, tag)) == null) continue;
                return element;
            }
        }
        return id == 0 || id == -2 ? new ContainerMultipartSync((TileSonarMultipart)obj) : null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        if (id == -2) {
            return new GuiInfoSource(this, this.getGSI(), (Container)new ContainerMultipartSync((TileSonarMultipart)obj));
        }
        if (this.elements != null) {
            for (IDisplayElement e : this.elements) {
                Object element;
                if (!(e instanceof IFlexibleGui) || (element = ((IFlexibleGui)e).getClientElement(obj, id, world, player, tag)) == null) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public int getRequired() {
        return 1;
    }

    @Override
    public List<InfoUUID> getSelectedInfo() {
        return this.getInfoReferences();
    }

    @Override
    public void onGuiClosed(List<InfoUUID> selected) {
        GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createInfoRequirementPacket(selected), this.getElementIdentity(), this.getGSI());
    }

    @Override
    public void doInfoRequirementPacket(DisplayGSI gsi, EntityPlayer player, List<InfoUUID> require) {
        InfoUUID infoUUID = require.get(0);
        if (InfoUUID.valid(infoUUID)) {
            this.getHolder().getElements().addElement(new UnconfiguredInfoElement(infoUUID));
            this.getHolder().getElements().removeElement(this);
        }
    }
}

