/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types;

import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.core.tiles.displays.info.elements.NetworkEnergyListElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.types.BaseInfo;
import sonar.logistics.core.tiles.displays.info.types.fluids.ElementNetworkFluidGrid;
import sonar.logistics.core.tiles.displays.info.types.items.NetworkItemGridElement;
import sonar.logistics.core.tiles.readers.SortingHelper;

@ASMInfo(id="logiclist", modid="practicallogistics2")
public class LogicInfoList
extends BaseInfo<LogicInfoList>
implements INameableInfo<LogicInfoList> {
    public static final String id = "logiclist";
    public final SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(2).setDefault((Object)-1);
    public SyncTagType.INT identity = new SyncTagType.INT(0);
    public SyncTagType.STRING infoID = new SyncTagType.STRING(1);
    public ILogicListSorter listSorter = null;
    public boolean listChanged = true;
    public boolean wasRefreshed = false;

    public LogicInfoList() {
        this.syncList.addParts(new IDirtyPart[]{this.identity, this.infoID, this.networkID});
    }

    public LogicInfoList(int identity, String infoID, int networkID) {
        this.syncList.addParts(new IDirtyPart[]{this.identity, this.infoID, this.networkID});
        this.identity.setObject((Object)identity);
        this.infoID.setObject((Object)infoID);
        this.networkID.setObject((Object)networkID);
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public boolean isIdenticalInfo(LogicInfoList info) {
        return ((Integer)this.identity.getObject()).equals(info.identity.getObject());
    }

    @Override
    public boolean isMatchingInfo(LogicInfoList info) {
        return ((String)this.infoID.getObject()).equals(info.infoID.getObject()) && ((Integer)this.networkID.getObject()).equals(info.networkID.getObject());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof LogicInfoList;
    }

    @Override
    public boolean isValid() {
        return (Integer)this.identity.getObject() != -1;
    }

    @Override
    public LogicInfoList copy() {
        return new LogicInfoList((Integer)this.identity.getObject(), (String)this.infoID.getObject(), (Integer)this.networkID.getObject());
    }

    @Override
    public String getClientIdentifier() {
        return "List: " + ((String)this.infoID.getObject()).toLowerCase();
    }

    @Override
    public String getClientObject() {
        return "LIST";
    }

    @Override
    public String getClientType() {
        return "list";
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (nbt.func_74764_b("sorter")) {
            this.listSorter = SortingHelper.loadListSorter(nbt.func_74775_l("sorter"));
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (this.listSorter != null) {
            nbt.func_74782_a("sorter", (NBTBase)SortingHelper.saveListSorter(new NBTTagCompound(), this.listSorter, NBTHelper.SyncType.SAVE));
        }
        return nbt;
    }

    @Override
    public void createDefaultElements(List<IDisplayElement> toAdd, IElementStorageHolder h, InfoUUID uuid) {
        switch ((String)this.infoID.getObject()) {
            case "items": {
                toAdd.add(new NetworkItemGridElement(uuid));
                break;
            }
            case "fluid": {
                toAdd.add(new ElementNetworkFluidGrid(uuid));
                break;
            }
            case "energy": {
                toAdd.add(new NetworkEnergyListElement(uuid));
            }
        }
    }
}

