/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.fluids;

import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIClickPacketHelper;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.NetworkGridElement;
import sonar.logistics.core.tiles.displays.info.types.LogicInfoList;
import sonar.logistics.core.tiles.displays.info.types.fluids.GuiEditNetworkFluidlist;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

@ASMDisplayElement(id="n_fluid_l", modid="practicallogistics2")
public class ElementNetworkFluidGrid
extends NetworkGridElement<InfoNetworkFluid> {
    public static final String REGISTRY_NAME = "n_fluid_l";

    public ElementNetworkFluidGrid() {
    }

    public ElementNetworkFluidGrid(InfoUUID uuid) {
        super(uuid);
    }

    @Override
    public double getRenderWidth() {
        return Math.min(this.element_size, Math.min(this.getActualScaling()[0], this.getActualScaling()[1]));
    }

    @Override
    public double getRenderHeight() {
        return Math.min(this.element_size, Math.min(this.getActualScaling()[0], this.getActualScaling()[1]));
    }

    @Override
    public void renderGridElement(InfoNetworkFluid stack, int index) {
        this.grid_fill_percentage = 0.9;
        double elementWidth = this.width * this.grid_fill_percentage;
        double elementHeight = this.height * this.grid_fill_percentage;
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(stack.getFluidStack().getFluid().getStill().toString());
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.saveBlendState();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        DisplayElementHelper.drawRect(0.0, 0.0, elementWidth, elementHeight, PL2Colours.backgroundColour.getRGB());
        GlStateManager.func_179120_a((int)770, (int)771, (int)0, (int)1);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        RenderHelper.restoreBlendState();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.001);
        InfoRenderHelper.renderProgressBarWithSprite(sprite, elementWidth, elementHeight, stack.getStored(), stack.getStoredStack().capacity);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.001);
        InfoRenderHelper.renderCenteredStringsWithUniformScaling(Lists.newArrayList((Object[])new String[]{stack.getClientIdentifier(), stack.getClientObject()}), elementWidth, elementHeight, 10, 0.75, this.text_colour);
    }

    @Override
    public void onGridElementClicked(DisplayScreenClick click, LogicInfoList list, @Nullable InfoNetworkFluid stack) {
        int networkID = stack == null || stack.getNetworkSource() == -1 ? ((Integer)list.networkID.getObject()).intValue() : stack.getNetworkSource();
        GSIClickPacketHelper.sendGSIClickPacket(GSIClickPacketHelper.createFluidClickPacket(stack == null ? null : stack.getStoredStack(), networkID), this.getHolder().getContainer(), click);
    }

    @Override
    public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        return IGuiOrigin.withOrigin((IGuiOrigin)new GuiEditNetworkFluidlist(this, obj), (Object)origin);
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

