/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.items;

import net.minecraft.item.ItemStack;
import sonar.logistics.api.asm.ASMMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.lists.EnumListChange;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;

@ASMMonitoredValue(id="item_count", modid="practicallogistics2")
public class ItemCount
implements IMonitoredValue<MonitoredItemStack> {
    public static final String id = "item_count";
    public MonitoredItemStack item;
    public long old = 0L;
    public boolean isNew;

    public ItemCount(MonitoredItemStack stack) {
        this.reset(stack);
        this.isNew = true;
    }

    @Override
    public EnumListChange getChange() {
        if (this.isNew) {
            return EnumListChange.NEW_VALUE;
        }
        return EnumListChange.getChange(this.item.getStoredStack().stored, this.old);
    }

    @Override
    public void resetChange() {
        this.old = this.item.getStoredStack().stored;
        this.item.getStoredStack().stored = 0L;
        this.isNew = false;
    }

    @Override
    public void combine(MonitoredItemStack combine) {
        this.item.getStoredStack().stored += combine.getStoredStack().stored;
    }

    @Override
    public void combine(long stored) {
        this.item.getStoredStack().stored += stored;
    }

    @Override
    public boolean canCombine(MonitoredItemStack combine) {
        return this.item.getStoredStack().equalStack(combine.getStoredStack().item);
    }

    @Override
    public boolean canCombine(ItemStack combine) {
        return this.item.getStoredStack().equalStack(combine);
    }

    @Override
    public boolean isValid(Object info) {
        return info instanceof MonitoredItemStack;
    }

    @Override
    public MonitoredItemStack getSaveableInfo() {
        return this.item;
    }

    @Override
    public void reset(MonitoredItemStack fullInfo) {
        this.item = fullInfo.copy();
    }

    @Override
    public void setNew() {
        this.isNew = true;
    }

    @Override
    public boolean shouldDelete(EnumListChange change) {
        return change.shouldDelete() || this.item == null || this.item.getStored() == 0L;
    }
}

