/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.items;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.core.tiles.displays.info.IComparableInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.IJoinableInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.IProvidableInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.comparators.ComparableObject;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValueInfo;
import sonar.logistics.api.core.tiles.displays.info.register.LogicPath;
import sonar.logistics.api.core.tiles.displays.info.register.RegistryType;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.types.BaseInfo;
import sonar.logistics.core.tiles.displays.info.types.items.ItemCount;
import sonar.logistics.core.tiles.displays.info.types.items.NetworkItemElement;

@ASMInfo(id="items", modid="practicallogistics2")
public class MonitoredItemStack
extends BaseInfo<MonitoredItemStack>
implements IProvidableInfo<MonitoredItemStack>,
IJoinableInfo<MonitoredItemStack>,
INameableInfo<MonitoredItemStack>,
IComparableInfo<MonitoredItemStack>,
IMonitoredValueInfo<MonitoredItemStack> {
    public static final String id = "items";
    public final SyncNBTAbstract<StoredItemStack> itemStack = new SyncNBTAbstract(StoredItemStack.class, 0);
    public final SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(1).setDefault((Object)-1);

    public MonitoredItemStack() {
        this.syncList.addParts(new IDirtyPart[]{this.itemStack, this.networkID});
    }

    public MonitoredItemStack(StoredItemStack stack, int networkID) {
        this(stack);
        this.networkID.setObject((Object)networkID);
    }

    public MonitoredItemStack(StoredItemStack stack) {
        this.syncList.addParts(new IDirtyPart[]{this.itemStack, this.networkID});
        this.itemStack.setObject((INBTSyncable)stack);
    }

    @Override
    public boolean isIdenticalInfo(MonitoredItemStack info) {
        return this.getStoredStack().equals((Object)info.getStoredStack());
    }

    @Override
    public boolean isMatchingInfo(MonitoredItemStack info) {
        return this.getStoredStack().equalStack(info.getStoredStack().getItemStack()) && ((Integer)this.networkID.getObject()).equals(info.networkID.getObject());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof MonitoredItemStack;
    }

    @Override
    public boolean canJoinInfo(MonitoredItemStack info) {
        return this.isMatchingInfo(info);
    }

    @Override
    public IJoinableInfo joinInfo(MonitoredItemStack info) {
        ((StoredItemStack)this.itemStack.getObject()).add((StoredItemStack)info.itemStack.getObject());
        return this;
    }

    @Override
    public boolean isValid() {
        return this.itemStack.getObject() != null && ((StoredItemStack)this.itemStack.getObject()).item != null;
    }

    @Override
    public String getID() {
        return id;
    }

    public String toString() {
        if (this.itemStack.getObject() != null) {
            return ((StoredItemStack)this.itemStack.getObject()).toString();
        }
        return super.toString() + " : NULL";
    }

    public ItemStack getItemStack() {
        return ((StoredItemStack)this.itemStack.getObject()).getItemStack();
    }

    public StoredItemStack getStoredStack() {
        return (StoredItemStack)this.itemStack.getObject();
    }

    public long getStored() {
        return ((StoredItemStack)this.itemStack.getObject()).stored;
    }

    public int getNetworkSource() {
        return (Integer)this.networkID.getObject();
    }

    public void setNetworkSource(int id) {
        this.networkID.setObject((Object)id);
    }

    @Override
    public MonitoredItemStack copy() {
        return new MonitoredItemStack(((StoredItemStack)this.itemStack.getObject()).copy(), (Integer)this.networkID.getObject());
    }

    @Override
    public String getClientIdentifier() {
        return "Item: " + (this.itemStack.getObject() != null && ((StoredItemStack)this.itemStack.getObject()).getItemStack() != null ? ((StoredItemStack)this.itemStack.getObject()).getItemStack().func_82833_r() : "ITEMSTACK");
    }

    @Override
    public String getClientObject() {
        return this.itemStack.getObject() != null ? "" + ((StoredItemStack)this.itemStack.getObject()).stored : "ERROR";
    }

    @Override
    public String getClientType() {
        return id;
    }

    @Override
    public void createDefaultElements(List<IDisplayElement> toAdd, IElementStorageHolder h, InfoUUID uuid) {
        toAdd.add(new NetworkItemElement(uuid));
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        StoredItemStack stack = (StoredItemStack)this.itemStack.getObject();
        objects.add(new ComparableObject(this, "Stored", stack.stored));
        objects.add(new ComparableObject(this, "Damage", stack.getItemDamage()));
        objects.add(new ComparableObject(this, "NBT", stack.item.func_77942_o() ? stack.getTagCompound() : new NBTTagCompound()));
        return objects;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.TILE;
    }

    @Override
    public MonitoredItemStack setRegistryType(RegistryType type) {
        return this;
    }

    @Override
    public void setFromReturn(LogicPath path, Object returned) {
    }

    public static MonitoredItemStack findItemStack(List<MonitoredItemStack> stacks, ItemStack item) {
        for (MonitoredItemStack i : stacks) {
            if (!i.getStoredStack().equalStack(item)) continue;
            return i;
        }
        return null;
    }

    @Override
    public IMonitoredValue<MonitoredItemStack> createMonitoredValue() {
        return new ItemCount(this);
    }
}

