/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.items;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIClickPacketHelper;
import sonar.logistics.core.tiles.displays.info.elements.AbstractInfoElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IClickableElement;
import sonar.logistics.core.tiles.displays.info.types.items.GuiEditNetworkItem;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

@ASMDisplayElement(id="n_item", modid="practicallogistics2")
public class NetworkItemElement
extends AbstractInfoElement<MonitoredItemStack>
implements IClickableElement {
    public int text_colour = 0xFFFFFF;
    public static final String REGISTRY_NAME = "n_item";

    public NetworkItemElement() {
    }

    public NetworkItemElement(InfoUUID uuid) {
        super(uuid);
    }

    @Override
    public void render(MonitoredItemStack info) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)0.1);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.renderItemIntoGUI((ItemStack)info.getItemStack(), (int)0, (int)0);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
        GlStateManager.func_179132_a((boolean)false);
        RenderHelper.renderStoredItemStackOverlay((ItemStack)info.getItemStack(), (long)0L, (int)0, (int)0, (int)this.text_colour, (String)("" + info.getStored()), (boolean)false);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
    }

    @Override
    public int onGSIClicked(DisplayScreenClick click, EntityPlayer player, double subClickX, double subClickY) {
        this.info = this.getGSI().getCachedInfo(this.uuid);
        if (this.info != null && this.isType(this.info)) {
            MonitoredItemStack stack = (MonitoredItemStack)this.info;
            int networkID = stack.getNetworkSource();
            GSIClickPacketHelper.sendGSIClickPacket(GSIClickPacketHelper.createItemClickPacket(stack.getStoredStack(), networkID), this.getHolder().getContainer(), click);
        }
        return -1;
    }

    @Override
    public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        return IGuiOrigin.withOrigin((IGuiOrigin)new GuiEditNetworkItem(this, obj), (Object)origin);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.text_colour = nbt.func_74762_e("colour");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74768_a("colour", this.text_colour);
        return nbt;
    }

    @Override
    public boolean isType(IInfo info) {
        return info instanceof MonitoredItemStack;
    }

    @Override
    public int[] createUnscaledWidthHeight() {
        return new int[]{16, 16};
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

