/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.progress;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.lwjgl.input.Keyboard;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.client.gui.widgets.ScrollerOrientation;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.SonarHelper;
import sonar.logistics.base.gui.GuiLogistics;
import sonar.logistics.base.gui.buttons.LogisticsButton;
import sonar.logistics.base.requests.colour.CustomColourButton;
import sonar.logistics.base.requests.colour.GuiColourSelection;
import sonar.logistics.base.requests.colour.TextColourButton;
import sonar.logistics.core.tiles.displays.gsi.gui.GuiAbstractEditElements;
import sonar.logistics.core.tiles.displays.info.types.progress.ElementProgressBar;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public class GuiEditProgressBar
extends GuiAbstractEditElements {
    public ElementProgressBar element;

    public GuiEditProgressBar(ElementProgressBar element, TileAbstractDisplay display) {
        super(element, element.getHolder().getContainer(), display);
        this.element = element;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        for (int i = 0; i < 16; ++i) {
            TextFormatting format = TextFormatting.values()[i];
            this.field_146292_n.add(new TextColourButton((GuiSonar)this, 16 + i, this.field_147003_i + 2 + i * 14, this.field_147009_r + 210, format){

                @Override
                public boolean isSelected() {
                    return GuiLogistics.getCurrentColour() == this.colourRGB;
                }
            });
        }
        this.field_146292_n.add(new CustomColourButton(this, 15, this.field_147003_i + 8 + 224, this.field_147009_r + 210, "Configure Custom Colour"){

            @Override
            public boolean isSelected() {
                return false;
            }
        });
        this.spacing_scroller = new SonarScroller(this.field_147003_i + 90, this.field_147009_r + 151 + 20, 16, 80);
        this.spacing_scroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.setSpacingScroller((float)this.element.border_thickness);
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 0, this.field_147003_i + 4 + 176 + 54, this.field_147009_r + 152, 192, 32 + this.element.direction.ordinal() * 16, "Orientation", ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 1, this.field_147003_i + 4 + 176 + 54, this.field_147009_r + 152 + 18, 208, this.element.barType.ordinal() * 16, "Progress Bar Type", ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 2, this.field_147003_i + 4 + 176 + 54 - 18, this.field_147009_r + 152, 208, 224, "SET BAR COLOUR", ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 3, this.field_147003_i + 4 + 176 + 54 - 18, this.field_147009_r + 152 + 18, 208, 208, "SET BORDER COLOUR", ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 4, this.field_147003_i + 4 + 176 + 54 - 18, this.field_147009_r + 152 + 36, 208, 240, "SET Background COLOUR", ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 5, this.field_147003_i + 4 + 176 + 54, this.field_147009_r + 152 + 36, 32, 96, "Remove Background", ""));
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof TextColourButton) {
            GuiLogistics.setCurrentColour(FontHelper.getColourFromFormatting((TextFormatting)((TextColourButton)button).colour));
            return;
        }
        if (button instanceof CustomColourButton) {
            FMLCommonHandler.instance().showGuiScreen((Object)IGuiOrigin.withOrigin((IGuiOrigin)new GuiColourSelection(this.field_147002_h, this.entity), (Object)((Object)this)));
            return;
        }
        switch (button.field_146127_k) {
            case 0: {
                this.element.direction = (ElementProgressBar.ProgressBarDirection)SonarHelper.incrementEnum((Enum)this.element.direction, (Enum[])ElementProgressBar.ProgressBarDirection.values());
                this.reset();
                break;
            }
            case 1: {
                this.element.barType = (ElementProgressBar.ProgressBarType)SonarHelper.incrementEnum((Enum)this.element.barType, (Enum[])ElementProgressBar.ProgressBarType.values());
                this.reset();
                break;
            }
            case 2: {
                this.element.colour = GuiLogistics.getCurrentColour();
                break;
            }
            case 3: {
                this.element.border_colour = GuiLogistics.getCurrentColour();
                break;
            }
            case 4: {
                this.element.background_colour = GuiLogistics.getCurrentColour();
                break;
            }
            case 5: {
                this.element.background_colour = 0;
            }
        }
    }

    @Override
    public void setSpacingScroller(float scaling) {
        this.element.border_thickness = scaling;
        this.spacing_scroller.currentScroll = scaling;
    }
}

