/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.gui;

import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;

public class CursorPosition {
    public int x;
    public int y;

    public static CursorPosition newInvalid() {
        return new CursorPosition(-1, -1);
    }

    public CursorPosition(int[] pos) {
        this.setCursor(pos);
    }

    public CursorPosition(int x, int y) {
        this.setCursor(x, y);
    }

    public boolean validPosition() {
        return this.x != -1 && this.y != -1;
    }

    public void removeCursor() {
        this.setCursor(-1, -1);
    }

    public void setCursor(int[] set) {
        if (set == null) {
            this.removeCursor();
        } else {
            this.setCursor(set[0], set[1]);
        }
    }

    public void setCursor(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setYToFirst() {
        this.y = 0;
    }

    public void setXToFirst() {
        this.x = 0;
    }

    public void setYToLast(StyledTextElement text) {
        this.y = text.getLineCount() - 1;
    }

    public void setXToLast(StyledTextElement text) {
        this.x = this.y == -1 ? -1 : text.getLineLength(this.y);
    }

    public void moveX(StyledTextElement text, int moveX) {
        if (this.x == -1 || this.y == -1) {
            this.removeCursor();
            return;
        }
        int newIndex = this.x + moveX;
        int length = text.getLineLength(this.y);
        if (newIndex > length) {
            int oldY = this.y;
            this.moveY(text, 1);
            if (this.y != oldY) {
                this.setXToFirst();
            }
            return;
        }
        if (newIndex < 0) {
            int oldY = this.y;
            this.moveY(text, -1);
            if (this.y != oldY) {
                this.setXToLast(text);
            }
            return;
        }
        this.x = newIndex;
    }

    public void moveY(StyledTextElement text, int moveY) {
        int newY = Math.min(text.getLineCount() - 1, this.y + moveY);
        this.y = newY < 0 ? 0 : newY;
    }

    public StyledStringLine getTypingLine(StyledTextElement text) {
        return !this.validPosition() ? null : text.getLine(this.y);
    }

    public int getTypingIndex(StyledTextElement text) {
        return Math.min(this.x, text.getLineLength(this.y));
    }
}

