/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.ws.Holder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.base.gui.GuiLogistics;
import sonar.logistics.core.tiles.displays.gsi.gui.GuiAbstractEditElements;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.gui.CursorPosition;
import sonar.logistics.core.tiles.displays.info.types.text.gui.hotkeys.GuiActions;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.SonarStyling;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledInfo;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;
import sonar.logistics.core.tiles.displays.info.types.text.utils.StyledStringEditor;
import sonar.logistics.core.tiles.displays.info.types.text.utils.StyledStringFormatter;
import sonar.logistics.core.tiles.displays.info.types.text.utils.StyledStringHelper;
import sonar.logistics.core.tiles.displays.info.types.text.utils.TextSelection;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public abstract class GuiStyledStringFunctions
extends GuiAbstractEditElements {
    public final StyledTextElement text;
    public final CursorPosition cursorPosition = CursorPosition.newInvalid();
    public final CursorPosition selectPosition = CursorPosition.newInvalid();
    public List<TextSelection> savedSelections = new ArrayList<TextSelection>();
    public List<TextFormatting> specials = new ArrayList<TextFormatting>();

    public GuiStyledStringFunctions(StyledTextElement text, TileAbstractDisplay display) {
        super(text, text.getHolder().getContainer(), display);
        this.text = text;
    }

    public int[] getDragPositionFromMouseXY(int x, int y) {
        Tuple<Boolean, double[]> canClick = this.canClickContainer(x, y);
        if (!((Boolean)canClick.func_76341_a()).booleanValue()) {
            return new int[]{0, 0};
        }
        return this.getDragPositionFromContainerXY(((double[])canClick.func_76340_b())[0], ((double[])canClick.func_76340_b())[1]);
    }

    public abstract int[] getDragPositionFromContainerXY(double var1, double var3);

    public void onCarriageReturn() {
        if (this.cursorPosition.validPosition()) {
            GuiActions.DELETE_SELECTED.action.trigger(this);
            TextSelection afterCursor = new TextSelection(this.cursorPosition.x, Integer.MAX_VALUE, this.cursorPosition.y, this.cursorPosition.y);
            StyledStringLine line = new StyledStringLine(this.text);
            StyledStringFormatter.formatTextSelections(this.text, Lists.newArrayList((Object[])new TextSelection[]{afterCursor}), (l, ss) -> {
                line.addWithCombine((IStyledString)ss);
                return null;
            });
            this.text.addNewLine(this.cursorPosition.y + 1, line);
            this.cursorPosition.setCursor(0, this.cursorPosition.y + 1);
        }
    }

    public void addText(String toAppend) {
        StyledStringLine line;
        if (!this.cursorPosition.validPosition()) {
            this.cursorPosition.setYToLast(this.text);
            this.cursorPosition.setXToLast(this.text);
        }
        if (this.hasSelections()) {
            GuiActions.DELETE_SELECTED.action.trigger(this);
        }
        if ((line = this.cursorPosition.getTypingLine(this.text)) != null) {
            if (this.cursorPosition.x == 0) {
                if (line.getStrings().isEmpty()) {
                    line.setStrings(Lists.newArrayList((Object[])new IStyledString[]{new StyledString(toAppend, this.createStylingFromEnabled())}));
                } else {
                    IStyledString addTo = line.getStrings().get(0);
                    if (addTo instanceof StyledString) {
                        addTo.setUnformattedString(toAppend + addTo.getUnformattedString());
                    } else {
                        StyledString toAdd = new StyledString(toAppend, addTo.getStyle().copy());
                        StyledStringEditor.addStyledStrings(this.text, this.cursorPosition, Lists.newArrayList((Object[])new IStyledString[]{toAdd}));
                    }
                }
                this.cursorPosition.moveX(this.text, toAppend.length());
            } else {
                Holder hold = new Holder((Object)false);
                Holder string = new Holder();
                StyledStringFormatter.formatTextSelections(this.text, Lists.newArrayList((Object[])new TextSelection[]{this.getTypeBox()}), (l, ss) -> {
                    if (ss instanceof StyledString) {
                        ss.setUnformattedString(ss.getUnformattedString() + toAppend);
                        hold.value = true;
                        string.value = null;
                    } else {
                        string.value = ss;
                    }
                    return ss;
                });
                if (string.value != null) {
                    StyledStringEditor.addStyledStrings(this.text, this.cursorPosition, Lists.newArrayList((Object[])new IStyledString[]{new StyledString(toAppend, ((IStyledString)string.value).getStyle().copy())}));
                    hold.value = true;
                }
                if (((Boolean)hold.value).booleanValue()) {
                    this.cursorPosition.moveX(this.text, toAppend.length());
                }
            }
        }
    }

    public void removeText(int key) {
        if (this.cursorPosition.validPosition()) {
            if (this.hasSelections()) {
                GuiActions.DELETE_SELECTED.action.trigger(this);
            } else {
                StyledStringLine line = this.cursorPosition.getTypingLine(this.text);
                if (line == null) {
                    return;
                }
                if (line.getStrings().isEmpty()) {
                    if (this.text.getLines().size() != 1) {
                        this.text.deleteLine(this.cursorPosition.y);
                        this.cursorPosition.moveY(this.text, -1);
                        this.cursorPosition.setXToLast(this.text);
                    }
                    return;
                }
                Holder hold = new Holder((Object)false);
                if (key == 211) {
                    StyledStringFormatter.formatTextSelections(this.text, Lists.newArrayList((Object[])new TextSelection[]{this.getDeleteBox()}), (l, ss) -> {
                        hold.value = true;
                        return null;
                    });
                } else if (this.cursorPosition.x == 0) {
                    if (this.cursorPosition.y != 0) {
                        int newPosition = this.text.getLineLength(this.cursorPosition.y - 1);
                        StyledStringLine upLine = this.text.getLine(this.cursorPosition.y - 1);
                        line.forEach(upLine::addWithCombine);
                        this.text.deleteLine(this.cursorPosition.y);
                        this.cursorPosition.setY(this.cursorPosition.y - 1);
                        this.cursorPosition.setX(newPosition);
                    }
                } else {
                    StyledStringFormatter.formatTextSelections(this.text, Lists.newArrayList((Object[])new TextSelection[]{this.getBackspaceBox()}), (l, ss) -> {
                        hold.value = true;
                        return null;
                    });
                }
                if (((Boolean)hold.value).booleanValue()) {
                    this.cursorPosition.moveX(this.text, key == 211 ? 0 : -1);
                }
            }
        }
    }

    public TextSelection getTypeBox() {
        int typeIndex = this.cursorPosition.getTypingIndex(this.text);
        return new TextSelection(typeIndex - 1, typeIndex, this.cursorPosition.y, this.cursorPosition.y);
    }

    public TextSelection getBackspaceBox() {
        int typeIndex = this.cursorPosition.getTypingIndex(this.text);
        return new TextSelection(typeIndex - 1, typeIndex, this.cursorPosition.y, this.cursorPosition.y);
    }

    public TextSelection getDeleteBox() {
        int typeIndex = this.cursorPosition.getTypingIndex(this.text);
        return new TextSelection(typeIndex, typeIndex + 1, this.cursorPosition.y, this.cursorPosition.y);
    }

    public boolean checkAndCreateSelection() {
        if (this.selectPosition.validPosition()) {
            return true;
        }
        if (this.cursorPosition.validPosition()) {
            this.selectPosition.setCursor(this.cursorPosition.x, this.cursorPosition.y);
            return true;
        }
        return false;
    }

    public void cut() {
        this.copy();
        this.formatSelections((line, ss) -> null);
    }

    public void copy() {
        StringBuilder copyText = new StringBuilder();
        this.formatSelections((line, ss) -> {
            copyText.append(ss.getFormattedString());
            return ss;
        });
        GuiStyledStringFunctions.func_146275_d((String)copyText.toString());
    }

    public void paste() {
        List<StyledStringLine> lines;
        String paste = GuiStyledStringFunctions.func_146277_j();
        if (!paste.isEmpty() && !(lines = this.getStyledLinesFromString(paste)).isEmpty()) {
            StyledStringEditor.addStyledLines(this.text, this.cursorPosition, lines, true);
        }
    }

    public List<StyledStringLine> getStyledLinesFromString(String string) {
        String[] splits;
        ArrayList<StyledStringLine> lines = new ArrayList<StyledStringLine>();
        for (String s : splits = string.split("\n")) {
            StyledStringLine line = new StyledStringLine(this.text);
            StyledStringHelper.getStyledStringsFromText(s).forEach(line::addWithCombine);
            lines.add(line);
        }
        return lines;
    }

    public SonarStyling createStylingFromEnabled() {
        SonarStyling styling = new SonarStyling();
        styling.rgb = GuiLogistics.getCurrentColour();
        styling.toggleSpecialFormatting(this.specials, true);
        return styling;
    }

    @Override
    public void renderDisplayScreen(float partialTicks, int x, int y) {
        this.text.updateRender();
        this.text.getHolder().startElementRender(this.text);
        GlStateManager.func_179094_E();
        DisplayElementHelper.align(this.text.getHolder().getAlignmentTranslation(this.text));
        double scale = this.text.getActualScaling()[2];
        List<TextSelection> allSelection = this.getAllSelections();
        double[] scaling = DisplayElementHelper.getScaling(this.text.getUnscaledWidthHeight(), this.text.getMaxScaling(), 100.0);
        double max_width = this.text.getMaxScaling()[0];
        int i = 0;
        for (StyledStringLine s : this.text) {
            this.text.preRender(s);
            GlStateManager.func_179094_E();
            double element = (double)s.getStringWidth() * scaling[2];
            if (s.getAlign() == WidthAlignment.CENTERED) {
                GlStateManager.func_179137_b((double)(max_width / 2.0 - element / 2.0), (double)0.0, (double)0.0);
            }
            if (s.getAlign() == WidthAlignment.RIGHT) {
                GlStateManager.func_179137_b((double)(max_width - element), (double)0.0, (double)0.0);
            }
            GlStateManager.func_179139_a((double)scaling[2], (double)scaling[2], (double)1.0);
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            s.render();
            if (i == this.cursorPosition.y) {
                this.renderCursor(s);
            }
            this.renderSelections(allSelection, s, i);
            GlStateManager.func_179139_a((double)(1.0 / scaling[2]), (double)(1.0 / scaling[2]), (double)1.0);
            GlStateManager.func_179121_F();
            GL11.glTranslated((double)0.0, (double)((double)s.getStringHeight() * scaling[2]), (double)0.0);
            this.text.postRender(s);
            ++i;
        }
        GlStateManager.func_179121_F();
        this.text.getHolder().endElementRender(this.text);
    }

    public void renderCursorAtPosition() {
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        RenderHelper.drawRect((float)0.0f, (float)0.0f, (float)1.0f, (float)9.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.1);
    }

    public void renderCursor(StyledStringLine text) {
        if (this.cursorPosition.validPosition()) {
            int cursorPos = this.getCursorRenderPos(text);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
            RenderHelper.drawRect((float)cursorPos, (float)0.0f, (float)(cursorPos + 1), (float)9.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.1);
        }
    }

    public int getCursorRenderPos(StyledStringLine c) {
        return this.getCursorRenderPos(c, this.cursorPosition.getTypingIndex(this.text));
    }

    public int getCursorRenderPos(StyledStringLine c, int index) {
        int i = 0;
        if (!c.getStrings().isEmpty()) {
            boolean start = false;
            int end = index;
            if (end == 0) {
                return 0;
            }
            int index_count = 0;
            for (IStyledString ss : c.getStrings()) {
                int subEnd = Math.min(index_count + ss.getStringLength(), end) - index_count;
                if (subEnd <= 0) continue;
                if (ss instanceof StyledInfo) {
                    i += ss.getStringWidth();
                    ++index_count;
                    continue;
                }
                String unformatted = ss.getTextFormattingStyle() + ss.getUnformattedString().substring(0, subEnd);
                i += RenderHelper.fontRenderer.func_78256_a(unformatted);
                index_count += ss.getStringLength();
            }
        }
        return i;
    }

    public void renderSelections(List<TextSelection> toRender, StyledStringLine line, int i) {
        if (toRender != null && !toRender.isEmpty()) {
            String string = line.getCachedUnformattedString();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            for (TextSelection s : toRender) {
                int[] subSelect = s.getSubStringSize(string, i);
                if (subSelect[0] == -1 || subSelect[1] == -1) continue;
                int start = subSelect[0];
                int end = subSelect[1];
                int subIndex = 0;
                int subWidth = 0;
                for (IStyledString ss : line.getStrings()) {
                    int selectStart = Math.max(subIndex, start);
                    int selectEnd = Math.min(subIndex + ss.getStringLength(), end);
                    int subStart = selectStart - subIndex;
                    int subEnd = selectEnd - subIndex;
                    if (subStart >= 0 && subStart < subEnd) {
                        if (ss instanceof StyledInfo) {
                            RenderHelper.drawRect((float)subWidth, (float)0.0f, (float)(subWidth + ss.getStringWidth()), (float)line.getStringHeight());
                        } else {
                            String text = ss.getUnformattedString();
                            String before = subStart == 0 ? "" : text.substring(0, subStart);
                            int beforeWidth = before.isEmpty() ? 0 : RenderHelper.fontRenderer.func_78256_a(ss.getTextFormattingStyle() + before);
                            String formatString = text.substring(subStart, subEnd);
                            RenderHelper.drawRect((float)(beforeWidth + subWidth), (float)0.0f, (float)(beforeWidth + subWidth + RenderHelper.fontRenderer.func_78256_a(ss.getTextFormattingStyle() + formatString)), (float)line.getStringHeight());
                        }
                    }
                    subIndex += ss.getStringLength();
                    subWidth += ss.getStringWidth();
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.1);
        }
    }

    public final void changeSelectedColour(TextFormatting colour) {
        GuiLogistics.setCurrentColour(FontHelper.getColourFromFormatting((TextFormatting)colour));
    }

    public final void toggleSpecialFormatting(TextFormatting format) {
        if (this.specials.contains(format)) {
            this.specials.remove(format);
            this.onSpecialFormatChanged(format, false);
        } else {
            this.specials.add(format);
            this.onSpecialFormatChanged(format, true);
        }
    }

    public void onSpecialFormatChanged(TextFormatting format, boolean enabled) {
        if (enabled) {
            this.enableSpecialFormattingOnSelected(Lists.newArrayList((Object[])new TextFormatting[]{format}));
        } else {
            this.disableSpecialFormattingOnSelected(Lists.newArrayList((Object[])new TextFormatting[]{format}));
        }
    }

    public List<TextSelection> getAllSelections() {
        boolean hasCursorSelection;
        List<TextSelection> stored_map = this.savedSelections;
        boolean bl = hasCursorSelection = this.cursorPosition.validPosition() && this.selectPosition.validPosition();
        if (hasCursorSelection) {
            stored_map = new ArrayList<TextSelection>();
            for (TextSelection s : this.savedSelections) {
                stored_map.add(new TextSelection(s.startX, s.endX, s.endY, s.endY));
            }
            TextSelection cursorSelection = new TextSelection(this.cursorPosition, this.selectPosition);
            TextSelection.addWithCombine(stored_map, cursorSelection);
        }
        return stored_map;
    }

    public List<TextSelection> combineAllSelections() {
        this.savedSelections = this.getAllSelections();
        return this.savedSelections;
    }

    public void selectAll() {
        this.savedSelections.clear();
        this.selectPosition.setCursor(0, 0);
        this.cursorPosition.setCursor(this.text.getLineLength(this.text.getLineCount() - 1), this.text.getLineCount() - 1);
    }

    public void deselectAll() {
        this.savedSelections.clear();
        this.selectPosition.removeCursor();
    }

    public boolean hasSelections() {
        return this.selectPosition.validPosition() || !this.savedSelections.isEmpty();
    }

    public void forCompounds(Consumer<StyledStringLine> format) {
        this.text.forEach(format::accept);
    }

    public void forStrings(Consumer<IStyledString> format) {
        this.text.forEach(t -> t.getStrings().forEach(format::accept));
    }

    public void enableSpecialFormattingOnSelected(List<TextFormatting> formatting) {
        this.formatSelections((line, ss) -> {
            ss.getStyle().toggleSpecialFormatting(formatting, true);
            ss.onStyleChanged();
            return ss;
        });
    }

    public void disableSpecialFormattingOnSelected(List<TextFormatting> formatting) {
        this.formatSelections((line, ss) -> {
            ss.getStyle().toggleSpecialFormatting(formatting, false);
            ss.onStyleChanged();
            return ss;
        });
    }

    public void setTextColourOnSelected(int colour) {
        this.formatSelections((line, ss) -> {
            ss.getStyle().setFontColour(colour);
            ss.onStyleChanged();
            return ss;
        });
    }

    public void deleteAllSelected() {
        this.formatSelections((line, ss) -> null);
        this.formatSelectedLines(ss -> ss.getStrings().isEmpty() ? null : ss);
        this.selectPosition.removeCursor();
        this.savedSelections.clear();
    }

    public void formatSelections(BiFunction<Integer, IStyledString, IStyledString> action) {
        StyledStringFormatter.formatTextSelections(this.text, this.getAllSelections(), action);
    }

    public void formatSelectedLines(Function<StyledStringLine, StyledStringLine> action) {
        this.formatSelectedLines(this.getAllSelections(), action);
    }

    public void formatSelectedLines(List<TextSelection> selects, Function<StyledStringLine, StyledStringLine> action) {
        StyledStringFormatter.formatSelectedLines(this.text, selects, action);
        GuiActions.UPDATE_TEXT_SCALING.trigger(this);
        this.text.getHolder().getContainer().updateActualScaling();
    }

    public void onTextFieldFocused(SonarTextField field) {
        super.onTextFieldFocused(field);
        this.cursorPosition.removeCursor();
        this.selectPosition.removeCursor();
    }
}

