/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.gui.hotkeys;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.text.TextFormatting;
import sonar.logistics.core.tiles.displays.info.types.text.gui.GuiEditStyledStrings;
import sonar.logistics.core.tiles.displays.info.types.text.gui.hotkeys.GuiActions;
import sonar.logistics.core.tiles.displays.info.types.text.gui.hotkeys.IHotKeyAction;
import sonar.logistics.core.tiles.displays.info.types.text.gui.hotkeys.IKeyMatch;
import sonar.logistics.core.tiles.displays.info.types.text.gui.hotkeys.ITypingAction;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;

public enum HotKeyFunctions {
    HOME((c, i) -> i == 199 && !GuiScreen.func_146272_n(), (gui, string, chr, key) -> gui.cursorPosition.setXToFirst()),
    END((c, i) -> i == 207 && !GuiScreen.func_146272_n(), (gui, string, chr, key) -> gui.cursorPosition.setXToLast(gui.text)),
    UP((c, i) -> i == 200 && !GuiScreen.func_146272_n(), (gui, string, chr, key) -> gui.cursorPosition.moveY(gui.text, -1)),
    DOWN((c, i) -> i == 208 && !GuiScreen.func_146272_n(), (gui, string, chr, key) -> gui.cursorPosition.moveY(gui.text, -1)),
    LEFT((c, i) -> i == 203 && !GuiScreen.func_146272_n(), (gui, string, chr, key) -> gui.cursorPosition.moveX(gui.text, -1)),
    RIGHT((c, i) -> i == 205 && !GuiScreen.func_146272_n(), (gui, string, chr, key) -> gui.cursorPosition.moveX(gui.text, 1)),
    HOME_SHIFT((c, i) -> i == 199 && GuiScreen.func_146272_n(), (gui, string, chr, key) -> {
        if (gui.checkAndCreateSelection()) {
            gui.selectPosition.setXToFirst();
        }
    }),
    END_SHIFT((c, i) -> i == 207 && GuiScreen.func_146272_n(), (gui, string, chr, key) -> {
        if (gui.checkAndCreateSelection()) {
            gui.selectPosition.setXToLast(gui.text);
        }
    }),
    UP_SHIFT((c, i) -> i == 200 && GuiScreen.func_146272_n(), (gui, string, chr, key) -> {
        if (gui.checkAndCreateSelection()) {
            gui.selectPosition.moveY(gui.text, -1);
        }
    }),
    DOWN_SHIFT((c, i) -> i == 208 && GuiScreen.func_146272_n(), (gui, string, chr, key) -> {
        if (gui.checkAndCreateSelection()) {
            gui.selectPosition.moveY(gui.text, -1);
        }
    }),
    LEFT_SHIFT((c, i) -> i == 203 && GuiScreen.func_146272_n(), (gui, string, chr, key) -> {
        if (gui.checkAndCreateSelection()) {
            gui.selectPosition.moveX(gui.text, -1);
        }
    }),
    RIGHT_SHIFT((c, i) -> i == 205 && GuiScreen.func_146272_n(), (gui, string, chr, key) -> {
        if (gui.checkAndCreateSelection()) {
            gui.selectPosition.moveX(gui.text, 1);
        }
    }),
    BOLD((c, i) -> i == 49 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s(), (gui, string, chr, key) -> gui.toggleSpecialFormatting(TextFormatting.BOLD)),
    ITALIC((c, i) -> i == 23 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s(), (gui, string, chr, key) -> gui.toggleSpecialFormatting(TextFormatting.ITALIC)),
    UNDERLINE((c, i) -> i == 22 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s(), (gui, string, chr, key) -> gui.toggleSpecialFormatting(TextFormatting.UNDERLINE)),
    ENTER((c, i) -> i == 28 || i == 156, (gui, string, chr, key) -> gui.onCarriageReturn()),
    COPY((c, i) -> GuiScreen.func_175280_f((int)i), (gui, string, chr, key) -> gui.copy()),
    PASTE((c, i) -> GuiScreen.func_175279_e((int)i), (gui, string, chr, key) -> gui.paste()),
    CUT((c, i) -> GuiScreen.func_175277_d((int)i), (gui, string, chr, key) -> gui.cut()),
    BACKSPACE((c, i) -> i == 14, (gui, string, chr, key) -> gui.removeText(key)),
    DEL((c, i) -> i == 211, (gui, string, chr, key) -> gui.removeText(key)),
    SAVE((c, i) -> i == 31 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s(), (gui, chr, key) -> gui.save()),
    SELECT_ALL((c, i) -> GuiScreen.func_175278_g((int)i), (gui, chr, key) -> GuiActions.SELECT_ALL.trigger(gui)),
    DESELECT_ALL((c, i) -> c == '\u0004', (gui, chr, key) -> GuiActions.DESELECT_ALL.trigger(gui)),
    TYPE((c, i) -> ChatAllowedCharacters.func_71566_a((char)c), (gui, string, chr, key) -> gui.addText(Character.toString(chr)));

    public IKeyMatch key;
    public ITypingAction typeAction;
    public IHotKeyAction hotKeyAction;
    public boolean requiresLine;

    private HotKeyFunctions(IKeyMatch key, ITypingAction action) {
        this.key = key;
        this.typeAction = action;
        this.requiresLine = true;
    }

    private HotKeyFunctions(IKeyMatch key, IHotKeyAction action) {
        this.key = key;
        this.hotKeyAction = action;
        this.requiresLine = false;
    }

    public static boolean checkFunction(GuiEditStyledStrings gui, StyledStringLine string, char c, int i) {
        for (HotKeyFunctions func : HotKeyFunctions.values()) {
            if (func.requiresLine && string == null || !func.key.canTriggerFunction(c, i)) continue;
            if (func.requiresLine) {
                func.typeAction.trigger(gui, string, c, i);
            } else {
                func.hotKeyAction.trigger(gui, c, i);
            }
            return true;
        }
        return false;
    }
}

