/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.utils;

import java.util.List;
import sonar.logistics.core.tiles.displays.info.types.text.gui.CursorPosition;

public class TextSelection {
    public int startY;
    public int endY;
    public int startX;
    public int endX;

    public TextSelection(int startX, int endX, int startY, int endY) {
        this.startX = startX;
        this.endX = endX;
        this.startY = startY;
        this.endY = endY;
    }

    public TextSelection(CursorPosition cursorPosition, CursorPosition selectPosition) {
        if (cursorPosition.y == selectPosition.y) {
            this.startY = cursorPosition.y;
            this.endY = cursorPosition.y;
            this.startX = Math.min(cursorPosition.x, selectPosition.x);
            this.endX = Math.max(cursorPosition.x, selectPosition.x);
        } else if (cursorPosition.y < selectPosition.y) {
            this.startY = cursorPosition.y;
            this.endY = selectPosition.y;
            this.startX = cursorPosition.x;
            this.endX = selectPosition.x;
        } else {
            this.startY = selectPosition.y;
            this.endY = cursorPosition.y;
            this.startX = selectPosition.x;
            this.endX = cursorPosition.x;
        }
    }

    public boolean canCombine(TextSelection selection) {
        return this.canCombine(selection.startX, selection.endX, selection.startY, selection.endY);
    }

    public boolean canCombine(int sX, int eX, int sY, int eY) {
        return TextSelection.check(this.startY, this.endY, sY, eY) && TextSelection.check(this.startX, this.endX, sX, eX);
    }

    public static boolean check(int start, int end, int s, int e) {
        if (start == s || start == e || end == s || end == e) {
            return true;
        }
        if (s > start && s < end) {
            return true;
        }
        if (e > start && e < end) {
            return true;
        }
        if (start > s && start < e) {
            return true;
        }
        return end > s && end < e;
    }

    public void combine(TextSelection selection) {
        this.combine(selection.startX, selection.endX, selection.startY, selection.endY);
    }

    public void combine(int sX, int eX, int sY, int eY) {
        if (sY == this.startY) {
            this.startX = Math.min(this.startX, sX);
        } else if (sY < this.startY) {
            this.startX = sX;
        }
        if (eY == this.endY) {
            this.endX = Math.max(this.endX, eX);
        } else if (sY > this.endX) {
            this.endX = eX;
        }
    }

    public int getStartX() {
        return this.startX;
    }

    public int getEndX() {
        return this.endX;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getEndY() {
        return this.endY;
    }

    public int[] getSubStringSize(String string, int yPos) {
        if (this.getStartY() > yPos || this.getEndY() < yPos) {
            return new int[]{-1, -1};
        }
        int length = string.length();
        int start = 0;
        int end = length;
        if (yPos == this.getStartY()) {
            start = Math.min(length, this.getStartX());
        }
        if (yPos == this.getEndY()) {
            end = Math.min(length, this.getEndX());
        }
        if (start == end) {
            return new int[]{-1, -1};
        }
        return new int[]{start, end};
    }

    public static void addWithCombine(List<TextSelection> selections, TextSelection select) {
        if (selections.isEmpty()) {
            selections.add(select);
            return;
        }
        for (TextSelection ss : selections) {
            if (!ss.canCombine(select)) continue;
            ss.combine(select);
            return;
        }
        selections.add(select);
    }
}

