/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles;

import javax.annotation.Nonnull;
import mcmultipart.api.container.IPartInfo;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.common.block.properties.SonarProperties;
import sonar.core.helpers.RayTraceHelper;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.base.events.PL2Events;
import sonar.logistics.core.tiles.displays.tiles.BlockAbstractDisplay;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public class BlockClickableDisplay
extends BlockAbstractDisplay {
    public BlockClickableDisplay(PL2Multiparts multipart) {
        super(multipart);
    }

    public boolean canPlayerDestroy(IPartInfo part, EntityPlayer player) {
        boolean canDestroy = this.canEntityDestroy(part.getState(), (IBlockAccess)part.getActualWorld(), part.getPartPos(), (Entity)player);
        if (!canDestroy) {
            this.func_180649_a(part.getPartWorld(), part.getPartPos(), player);
        }
        return canDestroy;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityPlayer) {
            RayTraceResult rayResult = RayTraceHelper.getRayTraceEyes((EntityPlayer)((EntityPlayer)entity));
            return rayResult == null || ((EnumFacing)state.func_177229_b((IProperty)SonarProperties.ORIENTATION)).func_176734_d() == rayResult.field_178784_b;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (!this.canEntityDestroy(state, (IBlockAccess)world, pos, (Entity)player)) {
            this.func_180649_a(world, pos, player);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (PL2Events.coolDownClick == 0) {
            PL2Events.coolDownClick = 2;
            RayTraceResult rayResult = RayTraceHelper.getRayTraceEyes((EntityPlayer)player);
            TileAbstractDisplay display = (TileAbstractDisplay)world.func_175625_s(pos);
            float hitX = (float)(rayResult.field_72307_f.field_72450_a - (double)pos.func_177958_n());
            float hitY = (float)(rayResult.field_72307_f.field_72448_b - (double)pos.func_177956_o());
            float hitZ = (float)(rayResult.field_72307_f.field_72449_c - (double)pos.func_177952_p());
            if (display.getGSI() != null) {
                display.getGSI().onClicked(display, player.func_70093_af() ? BlockInteractionType.SHIFT_LEFT : BlockInteractionType.LEFT, world, pos, world.func_180495_p(pos), player, player.func_184600_cs(), display.getCableFace(), hitX, hitY, hitZ);
            }
        }
    }
}

