/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles.holographic;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.core.tiles.displays.tiles.DisplayVectorHelper;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAbstractHolographicDisplay;

public class TileHolographicDisplay
extends TileAbstractHolographicDisplay
implements IByteBufTile {
    public static final Vec3d SCREEN_SCALE = new Vec3d(0.875, 0.875, 0.001);

    @Override
    public Vec3d getScreenScaling() {
        return SCREEN_SCALE;
    }

    @Override
    public Vec3d getScreenRotation() {
        return DisplayVectorHelper.getScreenRotation(this.getCableFace());
    }

    @Override
    public Vec3d getScreenOffset() {
        double x = 0.0;
        double y = this.getCableFace().func_176740_k().func_176722_c() ? 0.625 : 0.0;
        double z = this.getCableFace().func_176740_k().func_176720_b() ? 0.625 : 0.0;
        return new Vec3d(x, y, z).func_178787_e(DisplayVectorHelper.getFaceOffset(this.getCableFace(), 0.5));
    }

    @Override
    public void sendPropertiesToServer() {
        this.sendByteBufPacket(100);
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 100) {
            buf.writeInt(this.getScreenColour());
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 100) {
            this.screenColour.setObject((Object)buf.readInt());
            this.getGSI().getWatchers().forEach(watcher -> this.sendSyncPacket((EntityPlayer)watcher, NBTHelper.SyncType.SAVE));
        }
    }
}

