/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.misc.clock;

import io.netty.buffer.ByteBuf;
import java.text.SimpleDateFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.handlers.inventories.containers.ContainerMultipartSync;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.base.listeners.PL2ListenerList;
import sonar.logistics.core.tiles.base.TileSidedLogistics;
import sonar.logistics.core.tiles.displays.info.types.ClockInfo;
import sonar.logistics.core.tiles.misc.clock.GuiClock;

public class TileClock
extends TileSidedLogistics
implements IInfoProvider,
IByteBufTile,
IFlexibleGui {
    public static final ErrorMessage[] validStates = new ErrorMessage[0];
    public static final long[] tickAdjustments = new long[]{100L, -100L, 1000L, -1000L, 60000L, -60000L, 3600000L, -3600000L};
    public final PL2ListenerList listeners = new PL2ListenerList(this, ListenerType.ALL.size());
    public SyncTagType.LONG tickTime = new SyncTagType.LONG(1);
    public long lastMillis;
    public long currentMillis;
    public float rotation;
    public boolean isSet;
    public boolean lastSignal;
    public boolean wasStarted;
    public boolean powering;
    public long finalStopTime;

    public TileClock() {
        this.syncList.addParts(new IDirtyPart[]{this.tickTime});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isClient()) {
            return;
        }
        if ((Long)this.tickTime.getObject() >= 10L) {
            this.currentMillis = this.func_145831_w().func_82737_E() * 50L;
            long start = this.currentMillis - this.lastMillis;
            this.rotation = start * 360L / (Long)this.tickTime.getObject();
            if (start > (Long)this.tickTime.getObject()) {
                this.lastMillis = this.currentMillis;
                this.powering = true;
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 1);
            } else if (this.powering) {
                this.powering = false;
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 1);
            }
            this.func_70296_d();
            this.sendByteBufPacket(0);
            this.setClockInfo();
        }
    }

    public void setClockInfo() {
        ClockInfo info = null;
        if ((Long)this.tickTime.getObject() >= 10L) {
            long start = this.currentMillis - this.lastMillis;
            String timeString = new SimpleDateFormat("HH:mm:ss:SSS").format(start - 3600000L).substring(0, 11);
            info = new ClockInfo(start, ((Long)this.tickTime.getObject()).longValue(), timeString);
        }
        if (info != null) {
            InfoUUID id = new InfoUUID(this.getIdentity(), 0);
            IInfo oldInfo = ServerInfoHandler.instance().getInfoMap().get(id);
            if (!(oldInfo != null && oldInfo.isMatchingType(info) && oldInfo.isMatchingInfo(info) && oldInfo.isIdenticalInfo(info))) {
                ServerInfoHandler.instance().changeInfo(this, id, info);
            }
        }
    }

    @Override
    public IInfo getMonitorInfo(int pos) {
        return PL2.proxy.getInfoManager(this.isClient()).getInfoMap().get(new InfoUUID(this.getIdentity(), 0));
    }

    @Override
    public int getMaxInfo() {
        return 1;
    }

    @Override
    public PL2ListenerList getListenerList() {
        return this.listeners;
    }

    @Override
    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
        SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((PlayerListener)tally.listener).player);
    }

    public void onFirstTick() {
        super.onFirstTick();
        if (this.isServer()) {
            this.setClockInfo();
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.tickTime.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74757_a("isSet", this.isSet);
            nbt.func_74757_a("lastSignal", this.lastSignal);
            nbt.func_74757_a("wasStarted", this.wasStarted);
            nbt.func_74772_a("finalStopTime", this.finalStopTime);
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        this.tickTime.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.isSet = nbt.func_74767_n("isSet");
            this.lastSignal = nbt.func_74767_n("lastSignal");
            this.wasStarted = nbt.func_74767_n("wasStarted");
            this.finalStopTime = nbt.func_74763_f("finalStopTime");
        }
        return nbt;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                buf.writeFloat(this.rotation);
                break;
            }
            case 1: {
                this.tickTime.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -4: {
                this.sendByteBufPacket(-2);
                break;
            }
            case 0: {
                this.rotation = buf.readFloat();
                break;
            }
            case 1: {
                this.tickTime.readFromBuf(buf);
            }
        }
        if (id >= 2 && id <= 9) {
            this.tickTime.increaseBy(tickAdjustments[id - 2]);
        }
        if ((Long)this.tickTime.getObject() < 0L) {
            this.tickTime.setObject((Object)0L);
        } else if ((Long)this.tickTime.getObject() > 86400000L) {
            this.tickTime.setObject((Object)86399999L);
        }
    }

    public boolean hasStandardGui() {
        return true;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerMultipartSync((TileSonarMultipart)this) : null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiClock(this) : null;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    @Override
    public ErrorMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return EnumCableRenderSize.HALF;
    }
}

