/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.misc.hammer;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;
import sonar.logistics.core.tiles.misc.hammer.ContainerHammer;
import sonar.logistics.core.tiles.misc.hammer.GuiHammer;
import sonar.logistics.core.tiles.misc.hammer.HammerRecipes;

public class TileEntityHammer
extends TileEntityInventory
implements ISidedInventory,
IByteBufTile,
IFlexibleGui {
    public SyncTagType.INT progress = new SyncTagType.INT(0);
    public SyncTagType.INT coolDown = new SyncTagType.INT(1);
    public static int speed = 100;

    public TileEntityHammer() {
        this.inv.setSize(2);
        this.syncList.addParts(new IDirtyPart[]{this.progress, this.coolDown});
        this.inv.getInsertFilters().put((slot, amount, face) -> slot == 0, EnumFilterType.EXTERNAL);
        this.inv.getExtractFilters().put((slot, amount, face) -> slot == 1, EnumFilterType.EXTERNAL);
    }

    public NBTHelper.SyncType getUpdateTagType() {
        return NBTHelper.SyncType.SAVE;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if ((Integer)this.coolDown.getObject() != 0) {
            this.coolDown.increaseBy(-1);
        } else if (this.canProcess()) {
            if ((Integer)this.progress.getObject() < speed) {
                if ((Integer)this.progress.getObject() == 0) {
                    SonarCore.sendFullSyncAround((TileEntity)this, (int)64);
                }
                this.progress.increaseBy(1);
            } else {
                this.coolDown.setObject((Object)(speed * 2));
                this.progress.setObject((Object)0);
                if (!this.func_145831_w().field_72995_K) {
                    this.finishProcess();
                    SonarCore.sendFullSyncAround((TileEntity)this, (int)64);
                }
            }
        } else if ((Integer)this.progress.getObject() != 0) {
            this.progress.setObject((Object)0);
        }
    }

    public boolean canProcess() {
        if (((ItemStack)this.slots().get(0)).func_190926_b()) {
            return false;
        }
        ISonarRecipe recipe = HammerRecipes.instance().getRecipeFromInputs(null, new Object[]{this.slots().get(0)});
        if (recipe == null) {
            return false;
        }
        ItemStack outputStack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)0);
        if (outputStack.func_190926_b()) {
            return false;
        }
        if (!((ItemStack)this.slots().get(1)).func_190926_b()) {
            if (!((ItemStack)this.slots().get(1)).func_77969_a(outputStack)) {
                return false;
            }
            return ((ItemStack)this.slots().get(1)).func_190916_E() + outputStack.func_190916_E() <= ((ItemStack)this.slots().get(1)).func_77976_d();
        }
        return true;
    }

    public void finishProcess() {
        ISonarRecipe recipe = HammerRecipes.instance().getRecipeFromInputs(null, new Object[]{this.slots().get(0)});
        if (recipe == null) {
            return;
        }
        ItemStack outputStack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)0);
        if (!outputStack.func_190926_b()) {
            if (((ItemStack)this.slots().get(1)).func_190926_b()) {
                this.slots().set(1, outputStack.func_77946_l());
            } else if (((ItemStack)this.slots().get(1)).func_77969_a(outputStack)) {
                ((ItemStack)this.slots().get(1)).func_190917_f(outputStack.func_190916_E());
            }
            ((ItemStack)this.slots().get(0)).func_190918_g(((ISonarRecipeObject)recipe.inputs().get(0)).getStackSize());
            if (((ItemStack)this.slots().get(0)).func_190916_E() <= 0) {
                this.slots().set(0, ItemStack.field_190927_a);
            }
        }
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return slot == 0 && HammerRecipes.instance().isValidInput(stack);
    }

    public boolean maxRender() {
        return true;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int slot, @Nonnull ItemStack item, @Nonnull EnumFacing side) {
        return slot == 0;
    }

    public boolean func_180461_b(int slot, @Nonnull ItemStack item, @Nonnull EnumFacing side) {
        return slot == 1;
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        super.func_70299_a(i, itemstack);
        if (i == 1) {
            this.markBlockForUpdate();
            SonarCore.sendFullSyncAround((TileEntity)this, (int)64);
        }
    }

    public int getSpeed() {
        return speed;
    }

    public int getProgress() {
        return (Integer)this.progress.getObject();
    }

    public int getCoolDown() {
        return (Integer)this.coolDown.getObject();
    }

    public int getCoolDownSpeed() {
        return speed * 2;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.progress.writeToBuf(buf);
                break;
            }
            case 1: {
                this.coolDown.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.progress.readFromBuf(buf);
                break;
            }
            case 1: {
                this.coolDown.readFromBuf(buf);
            }
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerHammer(player, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiHammer(player, this);
    }
}

