/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.misc.signaller;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.handlers.inventories.containers.ContainerMultipartSync;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncNBTAbstractList;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.misc.signaller.IRedstoneSignaller;
import sonar.logistics.api.core.tiles.misc.signaller.SignallerModes;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.core.tiles.base.TileSidedLogistics;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;
import sonar.logistics.core.tiles.misc.signaller.GuiStatementList;
import sonar.logistics.core.tiles.misc.signaller.RedstoneSignallerStatement;

public class TileRedstoneSignaller
extends TileSidedLogistics
implements IRedstoneSignaller,
IByteBufTile,
IFlexibleGui {
    public static final ErrorMessage[] validStates = new ErrorMessage[]{ErrorMessage.NO_NETWORK, ErrorMessage.NO_STATEMENTS};
    public SyncTagType.BOOLEAN isActive = new SyncTagType.BOOLEAN(1);
    public SyncNBTAbstractList<RedstoneSignallerStatement> statements = new SyncNBTAbstractList(RedstoneSignallerStatement.class, 2);
    public SyncEnum<SignallerModes> mode = new SyncEnum((Enum[])SignallerModes.values(), 3);
    public static final Function<RedstoneSignallerStatement, Boolean> statement_func = s -> (Boolean)s.wasTrue.getObject();

    public TileRedstoneSignaller() {
        this.syncList.addParts(new IDirtyPart[]{this.isActive, this.statements, this.mode});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isClient()) {
            return;
        }
        if (this.statements.getObjects().isEmpty()) {
            this.isActive.setObject((Object)false);
            return;
        }
        ArrayList<InfoUUID> ids = new ArrayList<InfoUUID>();
        for (Iterator statement : this.statements.getObjects()) {
            ((RedstoneSignallerStatement)((Object)statement)).addRequiredUUIDs(ids);
        }
        HashMap<InfoUUID, IInfo> infoList = new HashMap<InfoUUID, IInfo>();
        for (InfoUUID id : ids) {
            IInfo monitorInfo;
            ILogicListenable monitor;
            if (infoList.containsKey(id) || (monitor = ServerInfoHandler.instance().getNetworkTileMap().get(id.getIdentity())) == null || !this.network.getGlobalInfoProviders().contains(monitor) || (monitorInfo = ServerInfoHandler.instance().getInfoMap().get(id)) == null) continue;
            infoList.put(id, monitorInfo);
        }
        for (RedstoneSignallerStatement s : this.statements.getObjects()) {
            boolean matching = s.isMatching(infoList).getBool();
            s.wasTrue.setObject((Object)matching);
        }
        boolean isValid = ((SignallerModes)this.mode.getObject()).checkList(this.statements.getObjects(), statement_func);
        this.isActive.setObject((Object)isValid);
    }

    @Override
    public SyncNBTAbstractList<RedstoneSignallerStatement> getStatements() {
        return this.statements;
    }

    @Override
    public SyncEnum<SignallerModes> emitterMode() {
        return this.mode;
    }

    public boolean isActive() {
        return (Boolean)this.isActive.getObject();
    }

    public void markChanged(IDirtyPart part) {
        super.markChanged(part);
        if (part == this.isActive) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, true);
            SonarMultipartHelper.sendMultipartPacketAround((TileSonarMultipart)this, (int)0, (int)128);
        }
    }

    public void onSyncPacketRequested(EntityPlayer player) {
        super.onSyncPacketRequested(player);
        InfoPacketHelper.sendLocalProviders(this, this.getIdentity(), player);
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.isActive.writeToBuf(buf);
                break;
            }
            case 1: {
                this.mode.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.isActive.readFromBuf(buf);
                if (!this.isClient()) break;
                this.markBlockForUpdate();
                break;
            }
            case 1: {
                this.mode.readFromBuf(buf);
            }
        }
    }

    public boolean hasStandardGui() {
        return true;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                InfoPacketHelper.sendLocalProviders(this, this.getIdentity(), player);
                SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerMultipartSync((TileSonarMultipart)this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiStatementList(player, this);
            }
        }
        return null;
    }

    @Override
    public ErrorMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return EnumCableRenderSize.NONE;
    }
}

