/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.nodes.array;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.handlers.inventories.SonarInventory;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.nodes.INode;
import sonar.logistics.api.core.tiles.wireless.transceivers.ITransceiver;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.events.LogisticsEventHandler;
import sonar.logistics.base.events.NetworkChanges;
import sonar.logistics.base.utils.LogisticsHelper;
import sonar.logistics.core.tiles.base.TileSidedLogistics;
import sonar.logistics.core.tiles.nodes.array.ContainerArray;
import sonar.logistics.core.tiles.nodes.array.GuiArray;

public class TileArray
extends TileSidedLogistics
implements INode,
IFlexibleGui {
    public static boolean entityChanged = true;
    public List<NodeConnection> channels = new ArrayList<NodeConnection>();
    public SyncTagType.INT priority = new SyncTagType.INT(1);
    public SonarInventory inventory = new SonarInventory(8){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileArray.this.updateConnectionLists();
        }

        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() instanceof ITransceiver;
        }

        public NBTHelper.SyncType[] getSyncTypes() {
            return new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE};
        }
    };

    public TileArray() {
        this.syncList.addParts(new IDirtyPart[]{this.priority, this.inventory});
    }

    public void func_73660_a() {
        super.func_73660_a();
    }

    public NBTHelper.SyncType getUpdateTagType() {
        return NBTHelper.SyncType.SAVE;
    }

    public void updateConnectionLists() {
        ArrayList<NodeConnection> channels = new ArrayList<NodeConnection>();
        for (int i = 0; i < 8; ++i) {
            NodeConnection connect;
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ITransceiver) || !stack.func_77942_o() || channels.contains(connect = LogisticsHelper.getTransceiverNode(this, this.field_145850_b, stack))) continue;
            channels.add(connect);
        }
        this.channels = channels;
        LogisticsEventHandler.instance().queueNetworkChange(this.network, NetworkChanges.LOCAL_CHANNELS);
    }

    @Override
    public int getPriority() {
        return (Integer)this.priority.getObject();
    }

    @Override
    public void addConnections(List<NodeConnection> connections) {
        connections.addAll(this.channels);
    }

    public void onFirstTick() {
        super.onFirstTick();
        this.updateConnectionLists();
    }

    public void onSyncPacketRequested(EntityPlayer player) {
        super.onSyncPacketRequested(player);
        this.inventory.markChanged();
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        if (id == 0) {
            SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerArray(player, this) : null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiArray(player, this) : null;
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return EnumCableRenderSize.HALF;
    }
}

